/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.eureka.grayscale.config;

import com.lwq.eureka.grayscale.filter.ServletHeaderFilter;
import com.lwq.eureka.grayscale.gray.CustomEurekaMetadataRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={DiscoveryEnabledNIWSServerList.class})
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
public class EurekaGrayAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public CustomEurekaMetadataRule customEurekaMetadataRule() {
        return new CustomEurekaMetadataRule();
    }

    @Bean
    public FilterRegistrationBean grayHeaderNameFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new ServletHeaderFilter());
        filterRegistration.addUrlPatterns(new String[]{"/*"});
        filterRegistration.setOrder(0);
        return filterRegistration;
    }
}

