package com.lwq.eureka.grayscale.gray;

import com.alibaba.ttl.TransmittableThreadLocal;

public class EurekaMetaDataContextHolder {

    private static final TransmittableThreadLocal<EurekaMetaDataContext> context = new TransmittableThreadLocal<EurekaMetaDataContext>(){
        @Override
        protected EurekaMetaDataContext initialValue() {
            return new EurekaMetaDataContext();
        }
    };

    public static EurekaMetaDataContext getContext() {
        return context.get();
    }

    public static void setContext(EurekaMetaDataContext context) {
        EurekaMetaDataContextHolder.context.set(context);
    }

    public static void remove() {
        context.remove();
    }


}