package com.lwq.eureka.grayscale.gray;

import lombok.Getter;
import lombok.Setter;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Setter
@Getter
public class EurekaMetaDataContext {

    private Map<String, String> eurekaMateMap = new ConcurrentHashMap<>();

    public EurekaMetaDataContext put(String key, String value) {
        eurekaMateMap.put(key, value);
        return this;
    }

    public String get(String key) {
        return eurekaMateMap.get(key);
    }

    public EurekaMetaDataContext remove(String key) {
        eurekaMateMap.remove(key);
        return this;
    }

    public Map<String, String> getEurekaMateMap() {
        return Collections.unmodifiableMap(eurekaMateMap);
    }

}