package com.lwq.eureka.grayscale.filter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.lwq.eureka.grayscale.constants.Constants;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import java.util.List;

/**
 * 针对spring cloud gateway做灰度处理
 */
@Configuration
@Slf4j
public class WebFluxFilter implements WebFilter, Ordered {

    @Override
    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        List<String> grayNameList = request.getHeaders().get(Constants.GRAY_HEADER_NAME);
        if (CollectionUtil.isNotEmpty(grayNameList)){
            String grayName = grayNameList.get(0);
            if (StrUtil.isNotBlank(grayName)){
                EurekaMetaDataContextHolder.getContext().put(Constants.GRAY_HEADER_NAME,grayName);
            }
        }
        return webFilterChain.filter(serverWebExchange).doOnError((e) ->{
            log.info("filter error",e);
        }).doOnSuccess((result) ->{
            log.info("filter success result={}", result);
        }).doFinally((onFinally) ->{
            EurekaMetaDataContextHolder.remove();
            log.info("finally onFinally={}",onFinally);
        });
    }


    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }


}
