package com.lwq.eureka.grayscale.filter;

import cn.hutool.core.util.StrUtil;
import com.lwq.eureka.grayscale.constants.Constants;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 基于servlet的过滤器，对web支持
 */
@Slf4j
public class ServletHeaderFilter implements Filter {

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try{
            HttpServletRequest request = (HttpServletRequest) servletRequest;
            //先从header中取traceId,如果取不到，在生成
            String grayName = request.getHeader(Constants.GRAY_HEADER_NAME);
            if (StrUtil.isNotBlank(grayName)){
                EurekaMetaDataContextHolder.getContext().put(Constants.GRAY_HEADER_NAME, grayName);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }catch (Exception e){
            log.error("GrayHeaderNameFilter doFilter error",e);
        }finally {
            EurekaMetaDataContextHolder.remove();
        }
    }

    @Override
    public void destroy() {
        EurekaMetaDataContextHolder.remove();
    }
}
