package com.lwq.eureka.grayscale.feign;

import com.lwq.eureka.grayscale.config.EurekaGrayAutoConfiguration;
import com.lwq.eureka.grayscale.constants.Constants;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

/**
 * feign调用时，
 */
@Configuration
@AutoConfigureBefore(EurekaGrayAutoConfiguration.class)
@Order(1)
public class FeignInterceptor implements RequestInterceptor{
    @Override
    public void apply(RequestTemplate requestTemplate) {
        String grayName = EurekaMetaDataContextHolder.getContext().get(Constants.GRAY_HEADER_NAME);
        requestTemplate.header(Constants.GRAY_HEADER_NAME,grayName);
    }

}
