package com.lwq.eureka.grayscale.config;

import com.lwq.eureka.grayscale.filter.ServletHeaderFilter;
import com.lwq.eureka.grayscale.gray.CustomEurekaMetadataRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(DiscoveryEnabledNIWSServerList.class)
@AutoConfigureBefore(RibbonClientConfiguration.class)
public class EurekaGrayAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public CustomEurekaMetadataRule customEurekaMetadataRule() {
        return new CustomEurekaMetadataRule();
    }



    @Bean
    public FilterRegistrationBean grayHeaderNameFilter(){
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter(new ServletHeaderFilter());
        filterRegistration.addUrlPatterns("/*");
        filterRegistration.setOrder(0);
        return filterRegistration;
    }


}
