/*
 * Decompiled with CFR 0.152.
 */
package com.wong.support.http.proxy;

import com.wong.support.http.Configuration;
import com.wong.support.http.exception.BindException;
import com.wong.support.http.proxy.ClientProxyFactory;
import java.util.HashMap;
import java.util.Map;

public class ClientRegistry {
    private final Map<Class<?>, ClientProxyFactory<?>> knownClients = new HashMap();
    private static volatile ClientRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientRegistry getInstance() {
        if (registry != null) {
            return registry;
        }
        Class<ClientRegistry> clazz = ClientRegistry.class;
        synchronized (ClientRegistry.class) {
            if (registry == null) {
                registry = new ClientRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    private ClientRegistry() {
    }

    public <T> T getClient(Class<T> type, Configuration configuration) {
        ClientProxyFactory<?> clientProxyFactory = this.knownClients.get(type);
        if (clientProxyFactory == null) {
            throw new BindException("\u7c7b\uff1a " + type + "\u672a\u53d1\u73b0\u6ce8\u518c\u5728 ClientRegistry");
        }
        try {
            return (T)clientProxyFactory.newInstance(configuration);
        }
        catch (Exception var5) {
            throw new BindException("\u83b7\u53d6client\u5b9e\u4f8b\u9519\u8bef. Cause: " + var5, var5);
        }
    }

    public <T> boolean hasClient(Class<T> type) {
        return this.knownClients.containsKey(type);
    }

    public <T> void addClient(Class<T> type) {
        if (type.isInterface()) {
            if (this.hasClient(type)) {
                throw new BindException("\u7c7b\uff1a " + type + "\u5df2\u7ecf\u6ce8\u518c\u5728 ClientRegistry.");
            }
            boolean loadCompleted = false;
            try {
                this.knownClients.put(type, new ClientProxyFactory<T>(type));
                loadCompleted = true;
            }
            finally {
                if (!loadCompleted) {
                    this.knownClients.remove(type);
                }
            }
        }
    }
}

