/*
 * Decompiled with CFR 0.152.
 */
package com.wong.support.http.proxy;

import com.wong.support.http.Configuration;
import com.wong.support.http.Context;
import com.wong.support.http.LoadBalanceEnum;
import com.wong.support.http.bean.NacosClient;
import com.wong.support.http.configuration.SupportClientProperties;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ClientProxy<T>
implements InvocationHandler,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ClientProxy.class);
    private static final long serialVersionUID = 8057508454903201403L;
    private final Class<T> clientInterface;
    private final Configuration configuration;
    private final AtomicInteger times = new AtomicInteger(0);

    public ClientProxy(Class<T> clientInterface, Configuration configuration) {
        this.clientInterface = clientInterface;
        this.configuration = configuration;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.intDomain();
        return Context.handle(method, args, this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intDomain() {
        int n;
        if (!StringUtils.hasText((String)this.configuration.getName()) && StringUtils.hasText((String)this.configuration.getUrl())) {
            this.configuration.setDomain(this.configuration.getUrl());
        }
        NacosClient nacosClient = this.getNacosClient();
        List<ServiceInstance> serviceInstances = nacosClient.getInstanceMap().get(this.configuration.getName());
        LoadBalanceEnum strategy = ((SupportClientProperties)this.configuration.getBeanFactory().getBean(SupportClientProperties.class)).getStrategy();
        switch (strategy) {
            case POLLING: {
                ReentrantLock lock = new ReentrantLock();
                lock.lock();
                try {
                    n = this.times.get() % serviceInstances.size();
                    this.times.set(n + 1);
                    break;
                }
                catch (Exception e) {
                    log.error("\u8f6e\u8be2\u7b97\u6cd5\u9519\u8bef\uff0c" + e.getMessage());
                    n = 0;
                    break;
                }
                finally {
                    lock.unlock();
                }
            }
            default: {
                n = (int)(Math.random() * (double)serviceInstances.size() * 10.0) % serviceInstances.size();
            }
        }
        ServiceInstance serviceInstance = serviceInstances.get(n);
        this.configuration.setDomain("http://" + serviceInstance.getHost() + ":" + serviceInstance.getPort());
    }

    private NacosClient getNacosClient() {
        NacosClient nacosClient = new NacosClient();
        DiscoveryClient client = (DiscoveryClient)this.configuration.getBeanFactory().getBean(DiscoveryClient.class);
        List services = client.getServices();
        if (CollectionUtils.isEmpty((Collection)services)) {
            return nacosClient;
        }
        HashMap<String, List<ServiceInstance>> map = new HashMap<String, List<ServiceInstance>>(16);
        for (String service : services) {
            List instances = client.getInstances(service);
            if (CollectionUtils.isEmpty((Collection)instances)) continue;
            instances.removeIf(e -> {
                Map metadata = e.getMetadata();
                if (metadata == null) {
                    return false;
                }
                return "false".equals(metadata.get("nacos.healthy"));
            });
            map.put(service, instances);
        }
        nacosClient.setInstanceMap(map);
        nacosClient.setServices(services);
        return nacosClient;
    }
}

