/*
 * Decompiled with CFR 0.152.
 */
package com.wong.support.http;

import com.alibaba.fastjson.JSONObject;
import com.wong.support.http.Configuration;
import com.wong.support.http.Handler;
import com.wong.support.http.annotation.Header;
import com.wong.support.http.annotation.Param;
import com.wong.support.http.annotation.RequestBody;
import com.wong.support.http.configuration.SupportClientProperties;
import com.wong.support.http.exception.IllegalParamException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object handle(Method method, Object[] args, Configuration configuration) {
        HttpRequestBase request;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        SupportClientProperties properties = (SupportClientProperties)configuration.getBeanFactory().getBean(SupportClientProperties.class);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(properties.getConnectTimeout().intValue()).setConnectionRequestTimeout(properties.getRequestTimeout().intValue()).build();
        Map<String, Handler> handlerMap = configuration.getHandlerMap();
        Handler handler = handlerMap.get(method.getName());
        if (handler == null) {
            throw new IllegalParamException("\u65b9\u6cd5\u6620\u5c04\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff1amethod name:" + method.getName());
        }
        String domain = configuration.getDomain();
        Parameter[] parameters = method.getParameters();
        StringBuilder url = new StringBuilder(domain + handler.getUri());
        switch (handler.getMethod()) {
            default: {
                request = Context.get(parameters, args, url);
                break;
            }
            case POST: {
                request = Context.post(parameters, args, url);
            }
        }
        request.setConfig(config);
        configuration.getDefaultHeaders().forEach((arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
        try {
            long l = System.currentTimeMillis();
            HttpResponse execute = client.execute((HttpUriRequest)request);
            HttpEntity entity = execute.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            int statusCode = execute.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                if (configuration.getIsPrintLog().booleanValue()) {
                    log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1a{}", (Object)request.getMethod());
                    log.info("\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)request.getURI());
                    log.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
                    log.info("\u54cd\u5e94\u65f6\u95f4\uff1a{}ms", (Object)(System.currentTimeMillis() - l));
                }
                if (Context.checkBasicType(method.getReturnType()).booleanValue()) {
                    String string = result;
                    return string;
                }
                Object object = JSONObject.parseObject((String)result, method.getReturnType());
                return object;
            }
            log.warn("support http \u8bf7\u6c42\u54cd\u5e94\u72b6\u6001\u7801\u5f02\u5e38,\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u72b6\u6001\u7801\uff1a{},\u76f8\u5173\u4fe1\u606f\uff1a{}", new Object[]{request.getURI(), statusCode, execute.getStatusLine().getReasonPhrase()});
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42/\u54cd\u5e94\u5931\u8d25 msg:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return null;
    }

    public static HttpRequestBase post(Parameter[] parameters, Object[] args, StringBuilder url) {
        HttpPost post = new HttpPost();
        HashMap<String, String> header = new HashMap<String, String>();
        url.append("?");
        boolean hasBody = false;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(Header.class)) {
                Header annotation = parameters[i].getAnnotation(Header.class);
                String headerName = annotation.value();
                if (!StringUtils.hasText((String)headerName)) {
                    headerName = parameters[i].getName();
                }
                header.put(headerName, (String)args[i]);
                continue;
            }
            if (parameters[i].isAnnotationPresent(RequestBody.class)) {
                Context.checkHasBody(hasBody, parameters[i].getName());
                if (Context.checkBasicType(args[i].getClass()).booleanValue()) {
                    throw new IllegalParamException("\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u5bf9\u5e94\u6ce8\u89e3\u4e0d\u5339\u914d\uff0c\u53c2\u6570\u7c7b\u578b\uff1a" + args[i].getClass());
                }
                url.deleteCharAt(url.length() - 1);
                StringEntity s = new StringEntity(JSONObject.toJSONString((Object)args[i]), "UTF-8");
                s.setContentType("application/json");
                post.setEntity((HttpEntity)s);
                hasBody = true;
                continue;
            }
            if (!parameters[i].isAnnotationPresent(Param.class)) continue;
            Context.checkHasBody(hasBody, parameters[i].getName());
            if (!Context.checkBasicType(args[i].getClass()).booleanValue()) {
                throw new IllegalParamException("\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u5bf9\u5e94\u6ce8\u89e3\u4e0d\u5339\u914d\uff0c\u53c2\u6570\u7c7b\u578b\uff1a" + args[i].getClass());
            }
            url.append(parameters[i].getName()).append("=").append(args[i]).append("&");
        }
        header.forEach((arg_0, arg_1) -> ((HttpPost)post).addHeader(arg_0, arg_1));
        post.setURI(URI.create(url.toString()));
        log.info("POST \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)post.getEntity());
        return post;
    }

    public static HttpRequestBase get(Parameter[] parameters, Object[] args, StringBuilder url) {
        HttpGet get = new HttpGet();
        HashMap<String, String> header = new HashMap<String, String>();
        url.append("?");
        boolean hasBody = false;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(Header.class)) {
                Header annotation = parameters[i].getAnnotation(Header.class);
                String headerName = annotation.value();
                if (!StringUtils.hasText((String)headerName)) {
                    headerName = parameters[i].getName();
                }
                header.put(headerName, (String)args[i]);
                continue;
            }
            if (parameters[i].isAnnotationPresent(RequestBody.class)) {
                Field[] fields;
                Context.checkHasBody(hasBody, parameters[i].getName());
                if (Context.checkBasicType(args[i].getClass()).booleanValue()) {
                    throw new IllegalParamException("\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u5bf9\u5e94\u6ce8\u89e3\u4e0d\u5339\u914d\uff0c\u53c2\u6570\u7c7b\u578b\uff1a" + args[i].getClass());
                }
                for (Field field : fields = parameters[i].getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    try {
                        url.append(field.getName()).append("=").append(field.get(args[i])).append("&");
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                hasBody = true;
                continue;
            }
            if (!parameters[i].isAnnotationPresent(Param.class)) continue;
            Context.checkHasBody(hasBody, parameters[i].getName());
            if (!Context.checkBasicType(args[i].getClass()).booleanValue()) {
                throw new IllegalParamException("\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u5bf9\u5e94\u6ce8\u89e3\u4e0d\u5339\u914d\uff0c\u53c2\u6570\u7c7b\u578b\uff1a" + args[i].getClass());
            }
            url.append(parameters[i].getName()).append("=").append(args[i]);
        }
        header.forEach((arg_0, arg_1) -> ((HttpGet)get).addHeader(arg_0, arg_1));
        get.setURI(URI.create(url.toString()));
        log.info("GET \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)get.getURI());
        return get;
    }

    private static void checkHasBody(Boolean hasBody, String name) {
        if (hasBody.booleanValue()) {
            throw new IllegalParamException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303\uff01\u53c2\u6570\u540d\uff1a" + name);
        }
    }

    public static Boolean checkBasicType(Class clazz) {
        if (clazz.getSimpleName().equals("String")) {
            return true;
        }
        if (clazz.getSimpleName().equals("Integer")) {
            return true;
        }
        if (clazz.getSimpleName().equals("Long")) {
            return true;
        }
        if (clazz.getSimpleName().equals("Double")) {
            return true;
        }
        if (clazz.getSimpleName().equals("Float")) {
            return true;
        }
        return clazz.getSimpleName().equals("Short");
    }
}

