/*
 * Decompiled with CFR 0.152.
 */
package com.wong.support.http;

import com.wong.support.http.Configuration;
import com.wong.support.http.Handler;
import com.wong.support.http.annotation.EnableSupportClients;
import com.wong.support.http.annotation.Request;
import com.wong.support.http.annotation.SupportClient;
import com.wong.support.http.exception.IllegalParamException;
import com.wong.support.http.properties.SupportGlobalConfigProperties;
import com.wong.support.http.proxy.ClientRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Order(value=100)
public class SupportClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware,
BeanFactoryAware {
    private ResourceLoader resourceLoader;
    private Environment environment;
    private BeanFactory beanFactory;
    private final ClientRegistry clientRegistry = ClientRegistry.getInstance();

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerSupportClients(metadata, registry);
    }

    public void registerSupportClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        LinkedHashSet candidateComponents = new LinkedHashSet();
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SupportClient.class));
        Set<String> basePackages = this.getBasePackages(metadata);
        for (String basePackage : basePackages) {
            candidateComponents.addAll(scanner.findCandidateComponents(basePackage));
        }
        for (BeanDefinition candidateComponent : candidateComponents) {
            try {
                Class<?> aClass = Class.forName(candidateComponent.getBeanClassName());
                this.clientRegistry.addClient(aClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
            this.registerFeignClient(registry, beanDefinition.getMetadata());
        }
    }

    private void registerFeignClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata) {
        String className = annotationMetadata.getClassName();
        Class clazz = ClassUtils.resolveClassName((String)className, null);
        Configuration configuration = this.initConfig(clazz);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz, () -> this.clientRegistry.getClient(clazz, configuration));
        definition.setAutowireMode(2);
        definition.setLazyInit(true);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setPrimary(true);
        Map attributes = annotationMetadata.getAnnotationAttributes(SupportClient.class.getCanonicalName());
        Assert.notNull((Object)attributes, (String)("SupportClient \u6ce8\u89e3\u4e0a\u7684\u5c5e\u6027\u672a\u627e\u5230\uff01\u76f8\u5173\u63a5\u53e3\uff1a" + clazz.getName()));
        String beanId = (String)attributes.get("beanId");
        if (!StringUtils.hasText((String)beanId)) {
            beanId = clazz.getSimpleName();
        }
        registry.registerBeanDefinition(beanId, (BeanDefinition)beanDefinition);
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    private Configuration initConfig(Class<?> clazz) {
        Method[] methods;
        Configuration configuration = new Configuration();
        HashMap<String, Handler> map = new HashMap<String, Handler>();
        SupportClient annotation = clazz.getAnnotation(SupportClient.class);
        if (annotation == null) {
            throw new IllegalParamException("client do not modification by @SupportClient!");
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(Request.class)) continue;
            Request request = method.getAnnotation(Request.class);
            String value = request.value();
            HttpMethod type = request.type();
            Handler handler = new Handler(type, value);
            map.put(method.getName(), handler);
        }
        if (!StringUtils.hasText((String)annotation.name()) && !StringUtils.hasText((String)annotation.url())) {
            throw new IllegalParamException("application name or url must be have one!");
        }
        SupportGlobalConfigProperties properties = (SupportGlobalConfigProperties)this.beanFactory.getBean(SupportGlobalConfigProperties.class);
        configuration.setDefaultHeaders(properties.getGlobalHeader());
        configuration.setIsPrintLog(properties.getLogPrint());
        configuration.setHandlerMap(map);
        configuration.setName(annotation.name());
        configuration.setUrl(annotation.url());
        configuration.setContextPath(annotation.contextPath());
        configuration.setBeanFactory(this.beanFactory);
        return configuration;
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableSupportClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("beanId");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("serviceId");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + SupportClient.class.getSimpleName());
    }
}

