package fz.vrd.ui.view.flowtag;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.List;

import fz.vrd.ui.R;

/**
 *
 * Created by Administrator on 2018/5/9.
 */

public class FlowTagAdapter extends BaseAdapter {

    Context context;

    List<FlowTagBean> list;

    String noUpdateId;

    public FlowTagAdapter(Context context, List<FlowTagBean> list) {
        this.context = context;
        this.list = list;
    }

    public FlowTagAdapter(Context context) {
        this.context = context;
    }

    //不可操作的id标签
    public void setNoUpdateId(String noUpdateId) {
        this.noUpdateId = noUpdateId;
    }

    public List<FlowTagBean> getListData() {
        return list;
    }

    public void setListData(List<FlowTagBean> list) {
        this.list = list;
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return list == null ? 0 : list.size();
    }

    @Override
    public FlowTagBean getItem(int position) {
        return list.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(context).inflate(R.layout.lib_ui_textview, null);
            holder.tvName = (TextView) convertView.findViewById(R.id.textView);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        holder.tvName.setText(getItem(position).name);
        if (getItem(position).isUpdate) {
            if (!TextUtils.isEmpty(noUpdateId) && noUpdateId.equals(getItem(position).id)) {
                holder.tvName.setBackgroundResource(R.color.gray);
                holder.tvName.setOnClickListener(null);
            } else {
                if (getItem(position).isCheck) {
                    holder.tvName.setBackgroundResource(R.color.red);
                } else {
                    holder.tvName.setBackgroundResource(R.color.blue);
                }
                holder.tvName.setTextColor(context.getColor(R.color.white));
                holder.tvName.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        list.get(position).isCheck = !getItem(position).isCheck;
                        notifyDataSetChanged();
                    }
                });
            }
        }
        return convertView;
    }

    private final class ViewHolder {
        TextView tvName;
    }
}
