package fz.vrd.ui.toast;

import android.annotation.SuppressLint;
import android.content.Context;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/**
 * <b>名称：Toast 弹框提示  <br/>
 * <b>创建人： VinRichard <br/>
 * <b>时间： 2021/6/10 14:22 <br/>
 * <b>备注：{  } <br/>
 */
public class ToastFactory implements Toast {

    static ToastFactory factory;

    Toast_I toastI;

    public static ToastFactory getInstance(){
        if(factory == null){
            factory = new ToastFactory();
        }
        return factory;
    }

    @Override
    public void showSys(Context context, String msg) {
        getToast().showSys(context,msg);
    }

    @Override
    public void showNomal(Context context, String msg) {
        getToast().showNomal(context,msg);
    }

    @Override
    public void showWarm(Context context, String msg) {
        getToast().showWarm(context,msg);
    }

    @Override
    public void showError(Context context, String msg) {
        getToast().showError(context,msg);
    }

    @Override
    public void showSuccess(Context context, String msg) {
        getToast().showSuccess(context,msg);
    }

    public Toast_I getToast(){
        if(toastI == null){
            toastI = new ToastImp();
        }
        return toastI;
    }

    /**
     * 如果通知权限没有开启 的话,toast谈不出来,这个时候调用这个方法局可以显示Toast
     */
    public  void showSystemToast(android.widget.Toast toast) {
        try {
            @SuppressLint("SoonBlockedPrivateApi")
            Method getServiceMethod = android.widget.Toast.class.getDeclaredMethod("getService");
            getServiceMethod.setAccessible(true);

            final Object iNotificationManager = getServiceMethod.invoke(null);
            Class iNotificationManagerCls = Class.forName("android.app.INotificationManager");
            Object iNotificationManagerProxy = Proxy.newProxyInstance(toast.getClass().getClassLoader(), new Class[]{iNotificationManagerCls}, new InvocationHandler() {
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    // 强制使用系统Toast
                    // 华为p20 pro上为enqueueToastEx
                    if ("enqueueToast".equals(method.getName())
                            || "enqueueToastEx".equals(method.getName())) {
                        args[0] = "android";
                    }
                    return method.invoke(iNotificationManager, args);
                }
            });
            Field sServiceFiled = android.widget.Toast.class.getDeclaredField("sService");
            sServiceFiled.setAccessible(true);
            sServiceFiled.set(null, iNotificationManagerProxy);
            toast.show();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
