package fz.vrd.ui.dialog;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import fz.vrd.ui.R;


public class TwoBtnDialog extends BaseDialogFragment {

    public static final String TITLE_KEY = "title";
    public static final String INFO_KEY = "info";
    public static final String BTN_OK_KEY = "btnOkInfo";
    public static final String BTN_CANCLE_KEY = "btnCancleInfo";

    TextView tv_title, tv_msg, btn_cancle, btn_ok;

    TwoBtnDialogListern listern;

    @Override
    public int getLayoutId() {
        return R.layout.lib_ui_two_btn_dialog;
    }

    @Override
    public float getDimAmount() {
        return 0.5f;
    }

    @Override
    public void initView() {
        tv_title = findViewById(R.id.tv_dialog_title);
        tv_msg = findViewById(R.id.tv_dialog_info);
        btn_cancle = findViewById(R.id.btn_dialog_cancle);
        btn_ok = findViewById(R.id.btn_dialog_ok);

        Bundle arguments = getArguments();
        tv_title.setText(TextUtils.isEmpty(arguments.getString(TITLE_KEY)) ? getStringMsg("warm_prompt", "提示") : arguments.getString(TITLE_KEY));
        tv_msg.setText(TextUtils.isEmpty(arguments.getString(INFO_KEY)) ? "" : arguments.getString(INFO_KEY));
        btn_cancle.setText(TextUtils.isEmpty(arguments.getString(BTN_CANCLE_KEY)) ? getStringMsg("cancel", "取消") : arguments.getString(BTN_CANCLE_KEY));
        btn_ok.setText(TextUtils.isEmpty(arguments.getString(BTN_OK_KEY)) ? getStringMsg("confirm", "确定") : arguments.getString(BTN_OK_KEY));

        btn_cancle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (listern != null) listern.listern(false);
                dismiss();
            }
        });
        btn_ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (listern != null) listern.listern(true);
                dismiss();
            }
        });
    }

    public void setOnClickListener(TwoBtnDialogListern listern) {
        this.listern = listern;
    }

    public interface TwoBtnDialogListern {

        public void listern(boolean isOk);
    }
}
