package fz.vrd.ui.dialog;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import fz.vrd.ui.R;


/**
 * <b>类名称或说明：一个按钮的对话框  <br/>
 * <b>创建人： Administrator <br/>
 * <b>时间： 2019/4/30 14:44<br/>
 * <b>修改备注：{ } <br/>
 */
public class OneBtnDialog extends BaseDialogFragment {

    public static final String TITLE_KEY = "title";
    public static final String INFO_KEY = "info";
    public static final String BTN_KEY = "btnInfo";


    View.OnClickListener listener;

    @Override
    public int getLayoutId() {

        return R.layout.lib_ui_one_btn_dialog;
    }

    @Override
    public float getDimAmount() {
        return 0.5f;
    }

    @Override
    public void initView() {
        TextView tv_title = findViewById(R.id.tv_dialog_title);
        TextView tv_msg = findViewById(R.id.tv_dialog_info);
        TextView tv_btn = findViewById(R.id.tv_one_dialog_one);
        Bundle arguments = getArguments();
        tv_title.setText(TextUtils.isEmpty(arguments.getString(TITLE_KEY)) ? getStringMsg("warm_prompt", "提示") : arguments.getString(TITLE_KEY));
        tv_msg.setText(TextUtils.isEmpty(arguments.getString(INFO_KEY)) ? "" : arguments.getString(INFO_KEY));
        tv_btn.setText(TextUtils.isEmpty(arguments.getString(BTN_KEY)) ? getStringMsg("confirm", "哦") : arguments.getString(BTN_KEY));
        tv_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if (listener != null) {
                    listener.onClick(view);
                }
            }
        });
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.listener = listener;
    }
}
