package fz.vrd.ui.dialog;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;

import java.util.ArrayList;
import java.util.Calendar;

import fz.vrd.ui.dialog.listener.CheckItemsCallBack;
import fz.vrd.ui.dialog.listener.OkOrCancleClickListener;
import fz.vrd.ui.dialog.listener.OneBtnClickListern;
import fz.vrd.ui.dialog.listener.PhotoAndCamerCheckListern;

/**
 * <b>类名称或说明：对话框工厂类  <br/>
 * <b>创建人： Administrator <br/>
 * <b>时间： 2019/4/29 18:07<br/>
 * <b>修改备注：{ } <br/>
 */
public class DialogFactory {

    static LoadingDialog dialog;

    static Handler handler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 0x01) {
                dismiss();
            } else if (msg.what == 0x02) {
                setLoadDialogFouseDismiss();
            }
        }
    };


    public static void loadDialog(FragmentActivity activity) {
        loadDialog(activity, null, "");
    }

    public static void loadDialog(FragmentActivity activity, String s) {
        loadDialog(activity, null, s);
    }

    public static void loadDialog(Fragment fragment) {
        loadDialog(null, fragment, "");
    }

    /**
     * 加载对话框
     */
    public static void loadDialog(FragmentActivity activity, Fragment fragment, String msg) {
        if (dialog != null) {
            dialog.dismiss();
            dialog = null;
        }
        dialog = new LoadingDialog();
        dialog.show(activity, fragment, msg);
        handler.sendEmptyMessageDelayed(0x01, 5 * 1000);
        handler.sendEmptyMessageDelayed(0x02, 10 * 1000);
    }

    public static void showOneBtnDialog(FragmentActivity activity, String msg, OneBtnClickListern callBack) {
        showOneBtnDialog(activity, null, null, msg, null, callBack);
    }

    public static void showOneBtnDialog(Fragment fragment, String msg, OneBtnClickListern callBack) {
        showOneBtnDialog(null, fragment, null, msg, null, callBack);
    }

    /**
     * 一个按钮的对话框
     */
    public static void showOneBtnDialog(FragmentActivity activity, Fragment fragment, String title, String msg, String btnMsg, final OneBtnClickListern callBack) {
        OneBtnDialog dialog = new OneBtnDialog();
        Bundle bundle = new Bundle();
        bundle.putString(OneBtnDialog.TITLE_KEY, title);
        bundle.putString(OneBtnDialog.INFO_KEY, msg);
        bundle.putString(OneBtnDialog.BTN_KEY, btnMsg);
        dialog.setArguments(bundle);
        dialog.show(activity, fragment, "");
        dialog.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (callBack != null) {
                    callBack.callBack();
                }
            }
        });
    }

    public static void showTwoBtnDialog(FragmentActivity activity, String msg, OkOrCancleClickListener callBack) {
        showTwoBtnDialog(activity, null, null, msg, null, null, callBack);
    }

    public static void showTwoBtnDialog(Fragment fragment, String msg, OkOrCancleClickListener callBack) {
        showTwoBtnDialog(null, fragment, null, msg, null, null, callBack);
    }

    public static void showTwoBtnDialog(FragmentActivity activity, String title, String msg, String okMsg, String cancleMsg, OkOrCancleClickListener callBack) {
        showTwoBtnDialog(activity, null, title, msg, okMsg, cancleMsg, callBack);
    }

    public static void showTwoBtnDialog(Fragment fragment, String title, String msg, String okMsg, String cancleMsg, OkOrCancleClickListener callBack) {
        showTwoBtnDialog(null, fragment, title, msg, okMsg, cancleMsg, callBack);
    }

    /**
     * 两个个按钮的对话框
     */
    public static void showTwoBtnDialog(FragmentActivity activity, Fragment fragment, String title, String msg, String okMsg, String cancleMsg, final OkOrCancleClickListener callBack) {
        TwoBtnDialog dialog = new TwoBtnDialog();
        Bundle bundle = new Bundle();
        bundle.putString(TwoBtnDialog.TITLE_KEY, title);
        bundle.putString(TwoBtnDialog.INFO_KEY, msg);
        bundle.putString(TwoBtnDialog.BTN_OK_KEY, okMsg);
        bundle.putString(TwoBtnDialog.BTN_CANCLE_KEY, cancleMsg);
        dialog.setArguments(bundle);
        dialog.show(activity, fragment, "");
        dialog.setOnClickListener(new TwoBtnDialog.TwoBtnDialogListern() {
            @Override
            public void listern(boolean isOk) {
                if (callBack != null) callBack.callBack(isOk);
            }
        });
    }


    public static void showStatueDialog(FragmentActivity activity, boolean isSuccess) {
        showStatueDialog(activity, isSuccess, null);
    }

    public static void showStatueDialog(FragmentActivity activity, boolean isSuccess, OkOrCancleClickListener callBack) {
        showStatueDialog(activity, null, null, isSuccess, callBack);
    }

    public static void showStatueDialog(Fragment fragment, boolean isSuccess, OkOrCancleClickListener callBack) {
        showStatueDialog(null, fragment, null, isSuccess, callBack);
    }

    public static void showStatueDialog(FragmentActivity activity, Fragment fragment, String msg, boolean isSuccess, OkOrCancleClickListener listern) {
        DealDialog dealDialog = new DealDialog();
        Bundle bundle = new Bundle();
        bundle.putBoolean(DealDialog.IS_OK_KEY, isSuccess);
        bundle.putString(DealDialog.MSG_KEY, msg);
        dealDialog.setArguments(bundle);
        dealDialog.show(activity, fragment, "");
        dealDialog.setOnClickListener(isSuccess1 -> {
            if (listern != null) listern.callBack(isSuccess1);
        });
    }

    public static void showPhotoDialog(Fragment fragment, PhotoAndCamerCheckListern callBack) {
        showPhotoDialog(null, fragment, callBack);
    }

    public static void showPhotoDialog(FragmentActivity activity, PhotoAndCamerCheckListern callBack) {
        showPhotoDialog(activity, null, callBack);
    }

    public static void checkTimeDialog(FragmentActivity activity, DatePickerDialog.OnDateSetListener listener) {
        Calendar ca = Calendar.getInstance();
        new DatePickerDialog(activity, AlertDialog.THEME_HOLO_LIGHT, listener, ca.get(Calendar.YEAR), ca.get(Calendar.MONTH), ca.get(Calendar.DAY_OF_MONTH)).show();

    }

    public static void timePickerDialog(FragmentActivity activity, TimePickerDialog.OnTimeSetListener listener) {
        Calendar ca = Calendar.getInstance();
        new TimePickerDialog(activity, TimePickerDialog.THEME_HOLO_LIGHT, listener, ca.get(Calendar.HOUR), ca.get(Calendar.MINUTE), true).show();
    }

    /**
     * 相册选择弹出对话框
     */
    public static void showPhotoDialog(FragmentActivity activity, Fragment fragment, final PhotoAndCamerCheckListern callBack) {
        PhotoAndCameraDialog dialog = new PhotoAndCameraDialog();
        dialog.show(activity, fragment, "");
        dialog.setOnClickListener(new PhotoAndCameraDialog.PhotoClickListern() {
            @Override
            public void listern(int index) {
                if (callBack != null) {
                    if (index == 0) {
                        callBack.cancle();
                    } else if (index == 1) {
                        callBack.camer();
                    } else if (index == 2) {
                        callBack.photo();
                    }
                }
            }
        });
    }

    public static void showCheckItemsDialog(Fragment fragment, ArrayList<String> list, CheckItemsCallBack callBack) {
        showCheckItemsDialog(null, fragment, list, callBack);
    }

    public static void showCheckItemsDialog(FragmentActivity activity, ArrayList<String> list, CheckItemsCallBack callBack) {
        showCheckItemsDialog(activity, null, list, callBack);
    }

    /**
     * 弹出选择框
     */
    public static void showCheckItemsDialog(FragmentActivity activity, Fragment fragment, ArrayList<String> list, CheckItemsCallBack callBack) {
        CheckItemsDialog dealDialog = new CheckItemsDialog();
        Bundle bundle = new Bundle();
        bundle.putStringArrayList(CheckItemsDialog.DATA_KEY, list);
        dealDialog.setArguments(bundle);
        dealDialog.show(activity, fragment, null);
        dealDialog.setOnClickListener((index, msg) -> {
            if (callBack != null) callBack.callBack(index, msg);
        });
    }

    public static void showCallPhoneDialog(FragmentActivity activity, String tel) {
        showTwoBtnDialog(activity, "提示", "确认拨打电话", "立即拨打", "取消", new OkOrCancleClickListener() {
            @Override
            public void callBack(boolean isOk) {
                if (isOk) {
                    Intent intent = new Intent(Intent.ACTION_DIAL);
                    Uri data = Uri.parse("tel:" + tel);
                    intent.setData(data);
                    activity.startActivity(intent);
                }
            }
        });
    }

    public static void dismiss() {
        if (dialog != null && dialog.isVisible()) {
            dialog.dismiss();
            dialog.onDestroy();
        }
        dialog = null;
    }

    static void setLoadDialogFouseDismiss() {
        if (dialog != null) {
            dialog.getDialog().setCancelable(true);
            dialog.getDialog().setCanceledOnTouchOutside(true);
        }
    }


}
