package fz.vrd.ui.dialog;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import fz.vrd.ui.R;

/**
 * <b>类名称或说明：操作的对话框  <br/>
 * <b>创建人： Administrator <br/>
 * <b>时间： 2019/5/5 11:10<br/>
 * <b>修改备注：{ } <br/>
 */
public class DealDialog extends BaseDialogFragment {

    public static final String IS_OK_KEY = "isOk";
    public static final String MSG_KEY = "msgInfo";

    ClickListern listener;

    @Override
    public int getLayoutId() {
        return R.layout.lib_ui_deal_dialog;
    }

    @Override
    public float getDimAmount() {
        return 0.5f;
    }

    @Override
    public void initView() {
        TextView tv_text = findViewById(R.id.tv_dialog_info);
        TextView tv_statue = findViewById(R.id.tv_dialog_statue);
        ImageView iv_statue = findViewById(R.id.iv_dialog_statue);
        Bundle arguments = getArguments();
        final boolean isOk = arguments.getBoolean(IS_OK_KEY);
        String msg = arguments.getString(MSG_KEY);
        iv_statue.setImageResource(isOk ? R.mipmap.lib_ui_ok_green : R.mipmap.lib_ui_error_red);
        tv_statue.setBackgroundResource(isOk ? R.drawable.lib_ui_shape_bg_radio5_green1 : R.drawable.lib_ui_shape_bg_radio5_red1);
        if (TextUtils.isEmpty(msg)) {
            tv_text.setText(getStringMsg(isOk ? "operate_successfully" : "there_was_a_mistake", isOk ? "操作成功" : "操作失败"));
        } else {
            tv_text.setText(msg);
        }

        tv_statue.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (listener != null) {
                    listener.isSuccess(isOk);
                }
                dismiss();
            }
        });
    }

    public void setOnClickListener(ClickListern listener) {
        this.listener = listener;
    }

    public interface ClickListern {

        void isSuccess(boolean isSuccess);
    }
}
