package fz.vrd.ui.dialog;


import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;

import fz.vrd.ui.R;

/**
 * <b>类名称或说明：多选对话框  <br/>
 * <b>创建人： Administrator <br/>
 * <b>时间： 2019/5/5 15:23<br/>
 * <b>修改备注：{ } <br/>
 */
public class CheckItemsDialog extends BaseDialogFragment {

    public final static String DATA_KEY = "data";

    CheckItemsListern listener;

    @Override
    public int getLayoutId() {
        return R.layout.lib_ui_check_items_dialog;
    }

    @Override
    public float getDimAmount() {
        return 0.3f;
    }

    @Override
    public int getDailogGravity() {
        return Gravity.BOTTOM;
    }

    @Override
    public boolean getCancelable() {
        return true;
    }

    @Override
    public void initView() {
        findViewById(R.id.btn_dialog_items_cancle).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
            }
        });
        final ArrayList<String> list = getArguments().getStringArrayList(DATA_KEY);
        if (list != null && list.size() > 0) {
            LinearLayout linearLayout = findViewById(R.id.ll_dialog_content);
            View view;
            TextView tv_name;
            for (int i = 0; i < list.size(); i++) {
                view = LayoutInflater.from(getActivity()).inflate(R.layout.lib_ui_textview, null);
                tv_name = view.findViewById(R.id.textView);
                tv_name.setBackgroundResource(R.drawable.lib_ui_selector_item_view);
                view.setTag(i);
                view.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if (listener != null) {
                            int index = (int) view.getTag();
                            listener.callBack(index, list.get(index));
                        }
                        dismiss();
                    }
                });
                tv_name.setText(list.get(i));
                linearLayout.addView(view);
            }
        }
        //设置背景色透明,在style中已设置backgroundDimEnabled为false,这里不需要.
        Window window = getDialog().getWindow();
        // 如果不设置这句代码, 那么弹框就会与四边都有一定的距离
        window.setBackgroundDrawableResource(android.R.color.transparent);
        WindowManager.LayoutParams windowParams = window.getAttributes();
        windowParams.dimAmount = 0.6f;
        if(list.size() > 10){
            windowParams.height = getResources().getDisplayMetrics().heightPixels * 8 / 10;
        }
        windowParams.width = getResources().getDisplayMetrics().widthPixels * 8 / 10;
        windowParams.gravity = Gravity.BOTTOM;
        window.setAttributes(windowParams);

    }



    public void setOnClickListener(CheckItemsListern listener) {
        this.listener = listener;
    }

    public interface CheckItemsListern {
        void callBack(int index, String msg);
    }
}
