package fz.vrd.ui.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;

import fz.vrd.ui.R;

/**
 * <b>类名称或说明：DialogFragment 的父类  <br/>
 * <b>创建人： Administrator <br/>
 * <b>时间： 2019/4/30 10:41<br/>
 * <b>修改备注：{ } <br/>
 */
public abstract class BaseDialogFragment extends DialogFragment {

    public abstract int getLayoutId();

    public abstract void initView();


    public <T extends View> T findViewById(int resId) {

        return getView().findViewById(resId);
    }

    public int getStypeId() {

        return R.style.dialogFragment_bg_transparent_style;
    }

    //获取dialog的显示位置
    public int getDailogGravity() {

        return Gravity.CENTER;
    }

    //获取dialog的动画
    public int getWindowAnimations() {

        return 0;
    }

    //获取dialog的是否可以触摸消失
    public boolean getCancelable() {

        return false;
    }

    public void show(FragmentActivity activity, Fragment fragment, String tag) {
        if (activity != null) {
            show(activity.getSupportFragmentManager(), tag);
        } else if (fragment != null) {
            show(fragment.getFragmentManager(), tag);
        } else {
            Log.e("BaseDialogFragment","==========showStatueDialog 当前上下文对象都为空=============");
        }
    }

    @Override
    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    @Override
    public void onAttachFragment(Fragment childFragment) {
        super.onAttachFragment(childFragment);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
    }

    @Override
    public void setStyle(int style, int theme) {
        super.setStyle(DialogFragment.STYLE_NO_FRAME, getStypeId());
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        return super.onCreateDialog(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getLayoutId() > 0) {
            return inflater.inflate(getLayoutId(), container);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        initView();
        getDialog().setCancelable(getCancelable());
        getDialog().setCanceledOnTouchOutside(getCancelable());

    }

    @Override
    public void onStart() {
        super.onStart();
        //设置背景色透明,在style中已设置backgroundDimEnabled为false,这里不需要.
        Window window = getDialog().getWindow();
        // 如果不设置这句代码, 那么弹框就会与四边都有一定的距离
        window.setBackgroundDrawableResource(android.R.color.transparent);
        // 设置动画
        if (getWindowAnimations() > 0) {
            window.setWindowAnimations(getWindowAnimations());
        }
        WindowManager.LayoutParams windowParams = window.getAttributes();
        windowParams.dimAmount = getDimAmount();
        windowParams.gravity = getDailogGravity();
        window.setAttributes(windowParams);

    }

    public String getStringMsg(String resId, String defalut) {
        int id = getResources().getIdentifier(resId, "string", getActivity().getPackageName());
        if (id > 0) {
            return !TextUtils.isEmpty(getString(id)) ? getString(id) : defalut;
        }
        return defalut;
    }

    public float getDimAmount() {
        return 0.6f;
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }
}
