/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.listener;

import com.riven.redisson.consts.ListenerType;
import com.riven.redisson.listener.AbstractRedissonListenerContainer;
import com.riven.redisson.listener.BatchRedissonListenerContainer;
import com.riven.redisson.listener.ContainerProperties;
import com.riven.redisson.listener.RedissonListenerContainer;
import com.riven.redisson.listener.RedissonListenerContainerFactory;
import com.riven.redisson.listener.SimpleRedissonListenerContainer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;

public class ConcurrentRedissonListenerContainer
extends AbstractRedissonListenerContainer {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentRedissonListenerContainer.class);
    private final int concurrency;
    private List<RedissonListenerContainer> containers = new ArrayList<RedissonListenerContainer>();
    private RedissonListenerContainerFactory containerFactory = new RedissonListenerContainerFactoryAdapter();

    public ConcurrentRedissonListenerContainer(ContainerProperties containerProperties, int concurrency) {
        super(containerProperties);
        Assert.isTrue((concurrency > 0 ? 1 : 0) != 0, (String)"concurrency must be greater than 0");
        this.concurrency = concurrency;
    }

    @Override
    protected void doStart() {
        for (int i = 0; i < this.concurrency; ++i) {
            RedissonListenerContainer container = this.containerFactory.createListenerContainer(this.getContainerProperties());
            container.setRedissonClient(this.getRedissonClient());
            container.setListener(this.getRedissonListener());
            container.start();
            this.containers.add(container);
        }
    }

    @Override
    protected void doStop() {
        this.containers.forEach(Lifecycle::stop);
        this.containers.clear();
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    private static class RedissonListenerContainerFactoryAdapter
    implements RedissonListenerContainerFactory {
        private RedissonListenerContainerFactoryAdapter() {
        }

        @Override
        public RedissonListenerContainer createListenerContainer(ContainerProperties containerProperties) {
            ListenerType listenerType = containerProperties.getListenerType();
            if (listenerType == ListenerType.BATCH) {
                return new BatchRedissonListenerContainer(containerProperties, containerProperties.getMaxFetch());
            }
            return new SimpleRedissonListenerContainer(containerProperties);
        }
    }
}

