/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.config;

import com.riven.redisson.config.QueueRegistryInfo;
import com.riven.redisson.config.RedissonQueueRegistry;
import com.riven.redisson.message.DefaultRedissonMessageConverter;
import com.riven.redisson.message.MessageConverter;
import com.riven.redisson.message.QueueMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.util.Assert;

public class RedissonTemplate
implements BeanFactoryAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(RedissonTemplate.class);
    private BeanFactory beanFactory;
    private RedissonQueueRegistry redissonQueueRegistry;
    private MessageConverter globalMessageConverter = new DefaultRedissonMessageConverter();

    public void setGlobalMessageConverter(MessageConverter globalMessageConverter) {
        Assert.notNull((Object)globalMessageConverter, (String)"MessageConverter must not be null");
        this.globalMessageConverter = globalMessageConverter;
    }

    public void send(String queueName, Object payload) {
        this.send(queueName, payload, new HashMap<String, Object>(8));
    }

    public void send(String queueName, Object payload, Map<String, Object> headers) {
        this.checkQueueAndPayload(queueName, payload);
        QueueRegistryInfo registryInfo = this.checkAndGetRegistryInfo(queueName);
        RBlockingQueue<Object> blockingQueue = registryInfo.getBlockingQueue();
        MessageConverter messageConverter = this.getRequiredMessageConverter(queueName);
        this.fillInfrastructureHeaders(queueName, headers);
        QueueMessage<?> message = messageConverter.toMessage(payload, headers);
        blockingQueue.offer(message);
    }

    public void sendWithDelay(String queueName, Object payload, long delay) {
        this.sendWithDelay(queueName, payload, new HashMap<String, Object>(8), delay);
    }

    public void sendWithDelay(String queueName, Object payload, Map<String, Object> headers, long delay) {
        this.checkQueueAndPayload(queueName, payload);
        Assert.isTrue((delay > 0L ? 1 : 0) != 0, (String)"delay millis must be positive");
        QueueRegistryInfo registryInfo = this.checkAndGetRegistryInfo(queueName);
        RDelayedQueue<Object> delayedQueue = registryInfo.getDelayedQueue();
        Assert.notNull(delayedQueue, (String)"the delay queue doesn't define");
        MessageConverter messageConverter = this.getRequiredMessageConverter(queueName);
        this.fillInfrastructureHeaders(queueName, headers);
        headers.put("expected_delay_millis", delay);
        QueueMessage<?> message = messageConverter.toMessage(payload, headers);
        delayedQueue.offer(message, delay, TimeUnit.MILLISECONDS);
    }

    private void checkQueueAndPayload(String queueName, Object payload) {
        Assert.hasText((String)queueName, (String)"queueName must not be empty");
        Assert.notNull((Object)payload, (String)"payload must not be null");
    }

    private QueueRegistryInfo checkAndGetRegistryInfo(String queueName) {
        QueueRegistryInfo registryInfo = this.redissonQueueRegistry.getRegistryInfo(queueName);
        Assert.notNull((Object)registryInfo, (String)"queue not registered");
        RBlockingQueue<Object> blockingQueue = registryInfo.getBlockingQueue();
        Assert.notNull(blockingQueue, (String)"target queue doesn't define");
        return registryInfo;
    }

    private MessageConverter getRequiredMessageConverter(String queueName) {
        QueueRegistryInfo registryInfo = this.redissonQueueRegistry.getRegistryInfo(queueName);
        MessageConverter messageConverter = registryInfo.getMessageConverter();
        if (messageConverter == null) {
            messageConverter = this.globalMessageConverter;
        }
        return messageConverter;
    }

    private void fillInfrastructureHeaders(String queueName, Map<String, Object> headers) {
        headers.put("delivery_queue_name", queueName);
        headers.put("send_timestamp", System.currentTimeMillis());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterSingletonsInstantiated() {
        this.redissonQueueRegistry = (RedissonQueueRegistry)this.beanFactory.getBean("com.riven.redisson.internalRedissonQueueRegistry", RedissonQueueRegistry.class);
    }

    public MessageConverter getGlobalMessageConverter() {
        return this.globalMessageConverter;
    }
}

