/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.config;

import com.riven.redisson.consts.ServerType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="spring.smart-redisson")
public class RedissonProperties {
    private ServerType serverType = ServerType.SINGLE;
    private String serverAddress = "redis://localhost:6379";
    private String password = "";
    private int database = 0;
    private int threads = 16;
    private int nettyThreads = 32;
    private int lockWatchdogTimeoutMillis = 30000;
    private int pingTimeoutMillis = 1000;
    private int connectTimeoutMillis = 10000;
    private int socketTimeoutMillis = 3000;
    private boolean keepAlive;
    private int retryAttempts = 3;
    private int retryIntervalMillis = 1500;
    private int maxPoolSize = 64;
    private int minIdleSize = 24;
    private int maxIdleMillis = 10000;
    private MasterSlaveProperties master;
    private MasterSlaveProperties slave;

    public void setDatabase(int database) {
        Assert.isTrue((database >= 0 ? 1 : 0) != 0, (String)"database must be gte 0");
        this.database = database;
    }

    public void setThreads(int threads) {
        Assert.isTrue((threads >= 0 ? 1 : 0) != 0, (String)"threads must be gte 0");
        this.threads = threads;
    }

    public void setNettyThreads(int nettyThreads) {
        Assert.isTrue((nettyThreads >= 0 ? 1 : 0) != 0, (String)"threads must be gte 0");
        this.nettyThreads = nettyThreads;
    }

    public void setLockWatchdogTimeoutMillis(int lockWatchdogTimeoutMillis) {
        Assert.isTrue((lockWatchdogTimeoutMillis > 0 ? 1 : 0) != 0, (String)"lockWatchdogTimeoutMillis must be gt 0");
        this.lockWatchdogTimeoutMillis = lockWatchdogTimeoutMillis;
    }

    public void setPingTimeoutMillis(int pingTimeoutMillis) {
        Assert.isTrue((pingTimeoutMillis > 0 ? 1 : 0) != 0, (String)"pingTimeoutMillis must be gt 0");
        this.pingTimeoutMillis = pingTimeoutMillis;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        Assert.isTrue((connectTimeoutMillis > 0 ? 1 : 0) != 0, (String)"connectTimeoutMillis must be gt 0");
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setSocketTimeoutMillis(int socketTimeoutMillis) {
        Assert.isTrue((socketTimeoutMillis > 0 ? 1 : 0) != 0, (String)"socketTimeoutMillis must be gt 0");
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    public void setRetryAttempts(int retryAttempts) {
        Assert.isTrue((retryAttempts >= 0 ? 1 : 0) != 0, (String)"retryAttempts must be gte 0");
        this.retryAttempts = retryAttempts;
    }

    public void setRetryIntervalMillis(int retryIntervalMillis) {
        Assert.isTrue((retryIntervalMillis > 0 ? 1 : 0) != 0, (String)"retryIntervalMillis must be gt 0");
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        Assert.isTrue((maxPoolSize > 0 ? 1 : 0) != 0, (String)"maxPoolSize must be gt 0");
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinIdleSize(int minIdleSize) {
        Assert.isTrue((minIdleSize >= 0 ? 1 : 0) != 0, (String)"minIdleSize must be gte 0");
        this.minIdleSize = minIdleSize;
    }

    public void setMaxIdleMillis(int maxIdleMillis) {
        Assert.isTrue((maxIdleMillis >= 0 ? 1 : 0) != 0, (String)"maxIdleMillis must be gte 0");
        this.maxIdleMillis = maxIdleMillis;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDatabase() {
        return this.database;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getNettyThreads() {
        return this.nettyThreads;
    }

    public int getLockWatchdogTimeoutMillis() {
        return this.lockWatchdogTimeoutMillis;
    }

    public int getPingTimeoutMillis() {
        return this.pingTimeoutMillis;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public int getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinIdleSize() {
        return this.minIdleSize;
    }

    public int getMaxIdleMillis() {
        return this.maxIdleMillis;
    }

    public MasterSlaveProperties getMaster() {
        return this.master;
    }

    public MasterSlaveProperties getSlave() {
        return this.slave;
    }

    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setMaster(MasterSlaveProperties master) {
        this.master = master;
    }

    public void setSlave(MasterSlaveProperties slave) {
        this.slave = slave;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedissonProperties)) {
            return false;
        }
        RedissonProperties other = (RedissonProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServerType this$serverType = this.getServerType();
        ServerType other$serverType = other.getServerType();
        if (this$serverType == null ? other$serverType != null : !((Object)((Object)this$serverType)).equals((Object)other$serverType)) {
            return false;
        }
        String this$serverAddress = this.getServerAddress();
        String other$serverAddress = other.getServerAddress();
        if (this$serverAddress == null ? other$serverAddress != null : !this$serverAddress.equals(other$serverAddress)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getNettyThreads() != other.getNettyThreads()) {
            return false;
        }
        if (this.getLockWatchdogTimeoutMillis() != other.getLockWatchdogTimeoutMillis()) {
            return false;
        }
        if (this.getPingTimeoutMillis() != other.getPingTimeoutMillis()) {
            return false;
        }
        if (this.getConnectTimeoutMillis() != other.getConnectTimeoutMillis()) {
            return false;
        }
        if (this.getSocketTimeoutMillis() != other.getSocketTimeoutMillis()) {
            return false;
        }
        if (this.isKeepAlive() != other.isKeepAlive()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getRetryIntervalMillis() != other.getRetryIntervalMillis()) {
            return false;
        }
        if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
            return false;
        }
        if (this.getMinIdleSize() != other.getMinIdleSize()) {
            return false;
        }
        if (this.getMaxIdleMillis() != other.getMaxIdleMillis()) {
            return false;
        }
        MasterSlaveProperties this$master = this.getMaster();
        MasterSlaveProperties other$master = other.getMaster();
        if (this$master == null ? other$master != null : !((Object)this$master).equals(other$master)) {
            return false;
        }
        MasterSlaveProperties this$slave = this.getSlave();
        MasterSlaveProperties other$slave = other.getSlave();
        return !(this$slave == null ? other$slave != null : !((Object)this$slave).equals(other$slave));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedissonProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServerType $serverType = this.getServerType();
        result = result * 59 + ($serverType == null ? 43 : ((Object)((Object)$serverType)).hashCode());
        String $serverAddress = this.getServerAddress();
        result = result * 59 + ($serverAddress == null ? 43 : $serverAddress.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + this.getDatabase();
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getNettyThreads();
        result = result * 59 + this.getLockWatchdogTimeoutMillis();
        result = result * 59 + this.getPingTimeoutMillis();
        result = result * 59 + this.getConnectTimeoutMillis();
        result = result * 59 + this.getSocketTimeoutMillis();
        result = result * 59 + (this.isKeepAlive() ? 79 : 97);
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getRetryIntervalMillis();
        result = result * 59 + this.getMaxPoolSize();
        result = result * 59 + this.getMinIdleSize();
        result = result * 59 + this.getMaxIdleMillis();
        MasterSlaveProperties $master = this.getMaster();
        result = result * 59 + ($master == null ? 43 : ((Object)$master).hashCode());
        MasterSlaveProperties $slave = this.getSlave();
        result = result * 59 + ($slave == null ? 43 : ((Object)$slave).hashCode());
        return result;
    }

    public String toString() {
        return "RedissonProperties(serverType=" + (Object)((Object)this.getServerType()) + ", serverAddress=" + this.getServerAddress() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", threads=" + this.getThreads() + ", nettyThreads=" + this.getNettyThreads() + ", lockWatchdogTimeoutMillis=" + this.getLockWatchdogTimeoutMillis() + ", pingTimeoutMillis=" + this.getPingTimeoutMillis() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", socketTimeoutMillis=" + this.getSocketTimeoutMillis() + ", keepAlive=" + this.isKeepAlive() + ", retryAttempts=" + this.getRetryAttempts() + ", retryIntervalMillis=" + this.getRetryIntervalMillis() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minIdleSize=" + this.getMinIdleSize() + ", maxIdleMillis=" + this.getMaxIdleMillis() + ", master=" + this.getMaster() + ", slave=" + this.getSlave() + ")";
    }

    public static class MasterSlaveProperties {
        private int maxPoolSize = 64;
        private int minIdleSize = 24;

        public void setMaxPoolSize(int maxPoolSize) {
            Assert.isTrue((maxPoolSize > 0 ? 1 : 0) != 0, (String)"maxPoolSize must be gt 0");
            this.maxPoolSize = maxPoolSize;
        }

        public void setMinIdleSize(int minIdleSize) {
            Assert.isTrue((minIdleSize >= 0 ? 1 : 0) != 0, (String)"minIdleSize must be gte 0");
            this.minIdleSize = minIdleSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getMinIdleSize() {
            return this.minIdleSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MasterSlaveProperties)) {
                return false;
            }
            MasterSlaveProperties other = (MasterSlaveProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
                return false;
            }
            return this.getMinIdleSize() == other.getMinIdleSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MasterSlaveProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxPoolSize();
            result = result * 59 + this.getMinIdleSize();
            return result;
        }

        public String toString() {
            return "RedissonProperties.MasterSlaveProperties(maxPoolSize=" + this.getMaxPoolSize() + ", minIdleSize=" + this.getMinIdleSize() + ")";
        }
    }
}

