/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.riven.redisson.message.RedissonMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class FastJsonCodec
extends StringCodec {
    public static final FastJsonCodec INSTANCE = new FastJsonCodec();
    private final Encoder encoder = object -> {
        String jsonStr = JSON.toJSONString((Object)object);
        return super.getValueEncoder().encode((Object)jsonStr);
    };
    private final Decoder<Object> decoder = (buf, state) -> {
        byte[] result = new byte[buf.readableBytes()];
        buf.readBytes(result);
        JSONObject jsonObject = (JSONObject)JSON.parse((byte[])result, (Feature[])new Feature[0]);
        Object payload = jsonObject.get((Object)"payload");
        String payloadStr = payload instanceof JSON ? ((JSON)payload).toJSONString() : JSON.toJSONString((Object)payload);
        JSONObject headers = jsonObject.getJSONObject("headers");
        return new RedissonMessage(payload == null ? new byte[]{} : payloadStr.getBytes(charset), (Map<String, Object>)headers);
    };

    public FastJsonCodec() {
        this(StandardCharsets.UTF_8);
    }

    public FastJsonCodec(Charset charset) {
        super(charset);
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

