/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.config;

import com.riven.redisson.annotation.RedissonListener;
import com.riven.redisson.config.RedissonListenerRegistry;
import com.riven.redisson.consts.ListenerType;
import com.riven.redisson.handler.IsolationStrategy;
import com.riven.redisson.handler.RedissonListenerErrorHandler;
import com.riven.redisson.listener.BatchRedissonMessageListenerAdapter;
import com.riven.redisson.listener.ContainerProperties;
import com.riven.redisson.listener.DefaultRedissonListenerContainerFactory;
import com.riven.redisson.listener.RedissonListenerContainer;
import com.riven.redisson.listener.RedissonListenerContainerFactory;
import com.riven.redisson.listener.RedissonMessageListener;
import com.riven.redisson.listener.SimpleRedissonMessageListenerAdapter;
import com.riven.redisson.message.MessageConverter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RedissonAnnotationBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(RedissonAnnotationBeanPostProcessor.class);
    private BeanFactory beanFactory;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private RedissonListenerContainerFactory redissonListenerContainerFactory;
    private RedissonListenerRegistry redissonListenerRegistry;
    private RedissonClient redissonClient;
    private List<ListenerDescriptor> listenerDescriptors = new ArrayList<ListenerDescriptor>(8);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        DefaultMessageHandlerMethodFactory handlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        handlerMethodFactory.setBeanFactory(beanFactory);
        handlerMethodFactory.afterPropertiesSet();
        this.messageHandlerMethodFactory = handlerMethodFactory;
        this.redissonListenerContainerFactory = new DefaultRedissonListenerContainerFactory();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        List<Method> allMethod = this.findAllMethod(clazz);
        allMethod.forEach(method -> this.processMethod(bean, (Method)method));
        return bean;
    }

    private List<Method> findAllMethod(Class clazz) {
        LinkedList<Method> methods = new LinkedList<Method>();
        ReflectionUtils.doWithMethods((Class)clazz, methods::add);
        return methods;
    }

    private void processMethod(Object bean, Method method) {
        String[] queues;
        RedissonListener annotation = (RedissonListener)AnnotationUtils.findAnnotation((Method)method, RedissonListener.class);
        if (annotation == null) {
            return;
        }
        int maxFetch = annotation.maxFetch();
        if (maxFetch <= 0) {
            throw new BeanDefinitionValidationException("maxFetch must be grater than 0");
        }
        for (String queue : queues = annotation.queues()) {
            InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(bean, method);
            ListenerDescriptor listenerDescriptor = new ListenerDescriptor();
            listenerDescriptor.setQueueInterested(queue);
            listenerDescriptor.setListenerType(maxFetch > 1 ? ListenerType.BATCH : ListenerType.SIMPLE);
            listenerDescriptor.setHandlerMethod(invocableHandlerMethod);
            listenerDescriptor.setErrorHandlerName(annotation.errorHandler());
            listenerDescriptor.setIsolationStrategyName(annotation.isolationStrategy());
            listenerDescriptor.setMessageConverterName(annotation.messageConverter());
            listenerDescriptor.setConcurrency(annotation.concurrency());
            listenerDescriptor.setMaxFetch(maxFetch);
            this.listenerDescriptors.add(listenerDescriptor);
        }
    }

    public void afterSingletonsInstantiated() {
        this.redissonClient = (RedissonClient)this.beanFactory.getBean(RedissonClient.class);
        this.redissonListenerRegistry = (RedissonListenerRegistry)this.beanFactory.getBean("com.riven.redisson.internalRedissonListenerRegistry", RedissonListenerRegistry.class);
        this.listenerDescriptors.forEach(descriptor -> {
            String queueInterested = descriptor.getQueueInterested();
            InvocableHandlerMethod invocableHandlerMethod = descriptor.getHandlerMethod();
            RedissonListenerErrorHandler errorHandler = null;
            IsolationStrategy isolationStrategy = null;
            String errorHandlerName = descriptor.getErrorHandlerName();
            String isolationStrategyName = descriptor.getIsolationStrategyName();
            String messageConverterName = descriptor.getMessageConverterName();
            if (StringUtils.hasText((String)errorHandlerName)) {
                errorHandler = (RedissonListenerErrorHandler)this.beanFactory.getBean(errorHandlerName, RedissonListenerErrorHandler.class);
            }
            ListenerType listenerType = descriptor.getListenerType();
            if (StringUtils.hasText((String)isolationStrategyName)) {
                isolationStrategy = (IsolationStrategy)this.beanFactory.getBean(isolationStrategyName, IsolationStrategy.class);
            }
            MessageConverter messageConverter = null;
            if (StringUtils.hasText((String)messageConverterName)) {
                messageConverter = (MessageConverter)this.beanFactory.getBean(messageConverterName, MessageConverter.class);
            } else {
                try {
                    messageConverter = (MessageConverter)this.beanFactory.getBean(MessageConverter.class);
                }
                catch (BeansException e) {
                    log.trace("no MessageConverter found for RedissonMessageListener to apply");
                }
            }
            MessageConverter payloadMessageConverter = messageConverter;
            String isolatedQueueName = isolationStrategy == null ? queueInterested : isolationStrategy.getRedisQueueName(queueInterested);
            ContainerProperties containerProperties = new ContainerProperties();
            containerProperties.setQueue(isolatedQueueName);
            containerProperties.setListenerType(listenerType);
            containerProperties.setErrorHandler(errorHandler);
            containerProperties.setIsolationStrategy(isolationStrategy);
            containerProperties.setMessageConverter(payloadMessageConverter);
            containerProperties.setConcurrency(descriptor.getConcurrency());
            containerProperties.setMaxFetch(descriptor.getMaxFetch());
            RedissonMessageListener messageListener = this.createMessageListener(containerProperties, invocableHandlerMethod);
            RedissonListenerContainer listenerContainer = this.redissonListenerContainerFactory.createListenerContainer(containerProperties);
            listenerContainer.setRedissonClient(this.redissonClient);
            listenerContainer.setListener(messageListener);
            this.redissonListenerRegistry.registerListenerContainer(listenerContainer);
        });
    }

    private RedissonMessageListener createMessageListener(ContainerProperties containerProperties, InvocableHandlerMethod invocableHandlerMethod) {
        if (containerProperties.getListenerType() == ListenerType.BATCH) {
            return new BatchRedissonMessageListenerAdapter(invocableHandlerMethod, containerProperties.getMessageConverter(), containerProperties.getErrorHandler());
        }
        return new SimpleRedissonMessageListenerAdapter(invocableHandlerMethod, containerProperties.getMessageConverter(), containerProperties.getErrorHandler());
    }

    private static class ListenerDescriptor {
        private String queueInterested;
        private ListenerType listenerType;
        private InvocableHandlerMethod handlerMethod;
        private String errorHandlerName;
        private String isolationStrategyName;
        private String messageConverterName;
        private int concurrency;
        private int maxFetch;

        public String getQueueInterested() {
            return this.queueInterested;
        }

        public ListenerType getListenerType() {
            return this.listenerType;
        }

        public InvocableHandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public String getErrorHandlerName() {
            return this.errorHandlerName;
        }

        public String getIsolationStrategyName() {
            return this.isolationStrategyName;
        }

        public String getMessageConverterName() {
            return this.messageConverterName;
        }

        public int getConcurrency() {
            return this.concurrency;
        }

        public int getMaxFetch() {
            return this.maxFetch;
        }

        public void setQueueInterested(String queueInterested) {
            this.queueInterested = queueInterested;
        }

        public void setListenerType(ListenerType listenerType) {
            this.listenerType = listenerType;
        }

        public void setHandlerMethod(InvocableHandlerMethod handlerMethod) {
            this.handlerMethod = handlerMethod;
        }

        public void setErrorHandlerName(String errorHandlerName) {
            this.errorHandlerName = errorHandlerName;
        }

        public void setIsolationStrategyName(String isolationStrategyName) {
            this.isolationStrategyName = isolationStrategyName;
        }

        public void setMessageConverterName(String messageConverterName) {
            this.messageConverterName = messageConverterName;
        }

        public void setConcurrency(int concurrency) {
            this.concurrency = concurrency;
        }

        public void setMaxFetch(int maxFetch) {
            this.maxFetch = maxFetch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListenerDescriptor)) {
                return false;
            }
            ListenerDescriptor other = (ListenerDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$queueInterested = this.getQueueInterested();
            String other$queueInterested = other.getQueueInterested();
            if (this$queueInterested == null ? other$queueInterested != null : !this$queueInterested.equals(other$queueInterested)) {
                return false;
            }
            ListenerType this$listenerType = this.getListenerType();
            ListenerType other$listenerType = other.getListenerType();
            if (this$listenerType == null ? other$listenerType != null : !((Object)((Object)this$listenerType)).equals((Object)other$listenerType)) {
                return false;
            }
            InvocableHandlerMethod this$handlerMethod = this.getHandlerMethod();
            InvocableHandlerMethod other$handlerMethod = other.getHandlerMethod();
            if (this$handlerMethod == null ? other$handlerMethod != null : !this$handlerMethod.equals(other$handlerMethod)) {
                return false;
            }
            String this$errorHandlerName = this.getErrorHandlerName();
            String other$errorHandlerName = other.getErrorHandlerName();
            if (this$errorHandlerName == null ? other$errorHandlerName != null : !this$errorHandlerName.equals(other$errorHandlerName)) {
                return false;
            }
            String this$isolationStrategyName = this.getIsolationStrategyName();
            String other$isolationStrategyName = other.getIsolationStrategyName();
            if (this$isolationStrategyName == null ? other$isolationStrategyName != null : !this$isolationStrategyName.equals(other$isolationStrategyName)) {
                return false;
            }
            String this$messageConverterName = this.getMessageConverterName();
            String other$messageConverterName = other.getMessageConverterName();
            if (this$messageConverterName == null ? other$messageConverterName != null : !this$messageConverterName.equals(other$messageConverterName)) {
                return false;
            }
            if (this.getConcurrency() != other.getConcurrency()) {
                return false;
            }
            return this.getMaxFetch() == other.getMaxFetch();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ListenerDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $queueInterested = this.getQueueInterested();
            result = result * 59 + ($queueInterested == null ? 43 : $queueInterested.hashCode());
            ListenerType $listenerType = this.getListenerType();
            result = result * 59 + ($listenerType == null ? 43 : ((Object)((Object)$listenerType)).hashCode());
            InvocableHandlerMethod $handlerMethod = this.getHandlerMethod();
            result = result * 59 + ($handlerMethod == null ? 43 : $handlerMethod.hashCode());
            String $errorHandlerName = this.getErrorHandlerName();
            result = result * 59 + ($errorHandlerName == null ? 43 : $errorHandlerName.hashCode());
            String $isolationStrategyName = this.getIsolationStrategyName();
            result = result * 59 + ($isolationStrategyName == null ? 43 : $isolationStrategyName.hashCode());
            String $messageConverterName = this.getMessageConverterName();
            result = result * 59 + ($messageConverterName == null ? 43 : $messageConverterName.hashCode());
            result = result * 59 + this.getConcurrency();
            result = result * 59 + this.getMaxFetch();
            return result;
        }

        public String toString() {
            return "RedissonAnnotationBeanPostProcessor.ListenerDescriptor(queueInterested=" + this.getQueueInterested() + ", listenerType=" + (Object)((Object)this.getListenerType()) + ", handlerMethod=" + this.getHandlerMethod() + ", errorHandlerName=" + this.getErrorHandlerName() + ", isolationStrategyName=" + this.getIsolationStrategyName() + ", messageConverterName=" + this.getMessageConverterName() + ", concurrency=" + this.getConcurrency() + ", maxFetch=" + this.getMaxFetch() + ")";
        }
    }
}

