package com.hsh.tangramlibrary.widget

import android.content.Context
import android.graphics.*
import android.support.v7.widget.AppCompatImageView
import android.util.AttributeSet
import android.view.View


/**
 * Created by Administrator on 2018/1/26.
 */
open class SquareImageView(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        AppCompatImageView(context, attrs, defStyleAttr) {
    constructor(context: Context, attrs: AttributeSet? = null) : this(context, attrs, 0)
    constructor(context: Context) : this(context, null)

    companion object {
        var DEFAULT_RADIUS = 20f
    }

    var squareModeFlag = false
    var cornerFlag = true
    var paint = Paint()
    var rectF = RectF()
    var xfermode = PorterDuffXfermode(PorterDuff.Mode.DST_OUT)
    var bm: Bitmap? = null
    var srcCanvas: Canvas? = null
    var radius = DEFAULT_RADIUS

    init {
        paint.color = Color.RED
        paint.xfermode = xfermode
        paint.isAntiAlias = true
        setLayerType(View.LAYER_TYPE_HARDWARE, null)
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
        if (squareModeFlag) {
            val length = if (measuredWidth > measuredHeight) {
                measuredHeight
            } else {
                measuredWidth
            }
            setMeasuredDimension(length, length)
        }
    }

    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(w, h, oldw, oldh)
        //先要搞一个傻逼的遮罩层，要和view一样大
        //此处是搞一个四个角的遮罩层，然后用clear，就把角搞出来了
        if (w == 0 || h == 0) {
            return
        }
        bm?.recycle()
        bm = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888)
        srcCanvas = Canvas(bm)
        paint.color = Color.WHITE
        paint.xfermode = null
        srcCanvas?.drawRect(0f, 0f, width.toFloat(), height.toFloat(), paint)
        paint.color = Color.WHITE
        paint.xfermode = PorterDuffXfermode(PorterDuff.Mode.DST_OUT)
        rectF.set(0f, 0f, width.toFloat(), height.toFloat())
        srcCanvas?.drawRoundRect(rectF, radius, radius, paint)
    }

    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)
        if (!cornerFlag || bm == null) {
            return
        }
        canvas.save()
        super.onDraw(canvas)
        paint.xfermode = xfermode
        canvas.drawBitmap(bm, 0f, 0f, paint)
        canvas.restore()
    }
}