/*
 * MIT License
 *
 * Copyright (c) 2017 Alibaba Group
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.hsh.tangramlibrary.widget

import android.content.Context
import android.util.AttributeSet
import android.widget.ImageView

import com.tmall.wireless.tangram.structure.BaseCell
import com.tmall.wireless.tangram.structure.CellRender
import com.tmall.wireless.tangram.util.ImageUtils
import com.tmall.wireless.tangram.util.Utils

/**
 * Created by villadora on 15/9/7.
 */
class SimpleImgView : RatioImageView {

    constructor(context: Context) : super(context) {
        scaleType = ImageView.ScaleType.FIT_XY
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        scaleType = ImageView.ScaleType.FIT_XY
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(context, attrs, defStyle) {
        scaleType = ImageView.ScaleType.FIT_XY
    }

    @CellRender
    fun cellInited(cell: BaseCell<*>) {
        setOnClickListener(cell)

    }

    @CellRender
    fun postBindView(cell: BaseCell<*>) {
        val imgUrl = cell.optStringParam("imgUrl")
        val imgRoundRadius = cell.optDoubleParam("imgRoundRadius")
        if(imgRoundRadius >= 0){
            radius = imgRoundRadius.toFloat()
        }
        val ratioFromUrl = Utils.getImageRatio(imgUrl)
        val padding = cell.style?.padding ?: intArrayOf(0, 0, 0, 0)
        setPadding(padding[0], padding[1], padding[2], padding[3])
        ratio = ratioFromUrl
        if (cell.style != null) {
            val aspectRatio = cell.style?.aspectRatio ?: Float.NaN
            if (!java.lang.Float.isNaN(aspectRatio)) {
                setRatio(aspectRatio, RatioImageView.PRIORITY_HIGH)
            }
        }
        ImageUtils.doLoadImageUrl(this, imgUrl)
        setOnClickListener(cell)
    }

    @CellRender
    fun postUnBindView(cell: BaseCell<*>) {
        ImageUtils.doLoadImageUrl(this, "")
    }
}
