package com.hsh.tangramlibrary.model

import android.view.View
import com.hsh.tangramlibrary.bean.CustomParentCellBean
import com.tmall.wireless.tangram.MVHelper
import com.tmall.wireless.tangram.core.service.ServiceManager
import com.tmall.wireless.tangram.dataparser.concrete.BaseCellBinderResolver
import com.tmall.wireless.tangram.dataparser.concrete.Card
import com.tmall.wireless.tangram.structure.BaseCell
import com.tmall.wireless.tangram.util.Utils
import org.json.JSONArray
import org.json.JSONObject
import java.util.*

/**
 * Created by Administrator on 2018/1/29.
 */
class CustomParentCell : BaseCell<View>() {

    var childrenCells: MutableList<BaseCell<*>>? = null
    override fun parseWith(data: JSONObject, resolver: MVHelper) {
        val array = data.getJSONArray(CustomParentCellBean.KEY_CHILDREN_CELLS)
        childrenCells = parseComponent(array, resolver)
    }

    private fun parseComponent(data: JSONArray?, cellResolver: MVHelper): MutableList<BaseCell<*>>? {
        if (data == null) {
            return mutableListOf()
        }
        val size = data.length()
        val result = ArrayList<BaseCell<*>>(size)
        //解析 body 组件
        val cellLength = data.length()
        (0 until cellLength)
                .map { data.optJSONObject(it) }
                .mapNotNull { createCell(cellResolver, it, this.serviceManager) }
                .filterTo(result) { cellResolver.isValid(it, serviceManager) }
        return result
    }

    private fun createCell(resolver: MVHelper, cellData: JSONObject?, serviceManager: ServiceManager?): BaseCell<*>? {
        if (cellData != null) {
            var cell: BaseCell<*>? = null
            val cellType = cellData.optString(Card.KEY_TYPE)
            if (resolver.resolver().getViewClass(cellType) != null || Utils.isCard(cellData)) {
                if (resolver.resolver().isCompatibleType(cellType)) {
                    cell = Utils.newInstance(resolver.resolver().getCellClass(cellType))
                    if (cell == null) {
                        return null
                    }
                    cell.serviceManager = serviceManager // ensure service manager
                } else {
                    cell = BaseCell<View>(cellType)
                    cell.serviceManager = serviceManager // ensure service manager
                }
                resolver.parseCell(resolver, cell, cellData)
                cell.setStringType(cellType) // ensure cell type
                return cell
            } else {
                //support virtual view at layout
                val componentBinderResolver = serviceManager?.getService(BaseCellBinderResolver::class.java)
                return if (componentBinderResolver?.has(cellType) == true) {
                    cell = BaseCell<View>(cellType)
                    cell.serviceManager = serviceManager // ensure service manager
                    resolver.parseCell(resolver, cell, cellData)
                    cell.setStringType(cellType) // ensure cell type
                    cell
                } else {
                    null
                }
            }
        }
        return null
    }
}