package com.hsh.tangramlibrary.widget

import android.content.Context
import android.graphics.Color
import android.os.Build
import android.support.v7.widget.CardView
import android.text.TextUtils
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.view.ViewOutlineProvider
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.hsh.tangramlibrary.bean.SimpleGridCellBean
import com.hsh.tangramlibrary.bean.style.GridCellStyle
import com.hsh.tangramlibrary.utils.Utils
import com.tmall.wireless.tangram.structure.BaseCell
import com.tmall.wireless.tangram.structure.view.ITangramViewLifeCycle
import com.tmall.wireless.tangram.util.ImageUtils

/**
 * 比SimpleImgView下面多了行字，如果没内容会自动隐藏
 * Created by Administrator on 2018/1/24.
 */
class SimpleGridCellView(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        ITangramViewLifeCycle, CardView(context, attrs, defStyleAttr) {
    constructor(context: Context, attrs: AttributeSet? = null) : this(context, attrs, 0)
    constructor(context: Context) : this(context, null)

    val title = TextView(context)
    val content = TextView(context)
    val layout = LinearLayout(context)
    private val imgView = SquareImageView(context)

    init {
        layout.orientation = LinearLayout.VERTICAL
        layout.gravity = Gravity.CENTER
        val layoutLayoutParams = LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT)
        layout.layoutParams = layoutLayoutParams

        val titleLayoutParams = LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT)
        title.layoutParams = titleLayoutParams
        title.ellipsize = TextUtils.TruncateAt.END

        val contentLayoutParams = LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT)
        content.layoutParams = contentLayoutParams
        content.ellipsize = TextUtils.TruncateAt.END

        val imgLayoutParams = LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, 0)
        imgLayoutParams.weight = 1f
        imgView.layoutParams = imgLayoutParams
        imgView.scaleType = ImageView.ScaleType.FIT_XY
        layout.addView(imgView)
        layout.addView(title)
        layout.addView(content)
        addView(layout)
//        radius = 0f
        clipToPadding = true
        preventCornerOverlap = true
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//            outlineProvider = ViewOutlineProvider.BOUNDS
//        }
    }

    override fun postBindView(cell: BaseCell<*>?) {
        val padding = cell?.style?.padding ?: intArrayOf(0, 0, 0, 0)
        val margin = cell?.style?.margin ?: intArrayOf(0, 0, 0, 0)
        layout.setPadding(padding[0], padding[1], padding[2], padding[3])
        val params: MarginLayoutParams = layoutParams as MarginLayoutParams
        params.setMargins(margin[0], margin[1], margin[2], margin[3])
        layoutParams = params
        val bgResource = try {
            cell?.style?.extras?.getInt(GridCellStyle.KEY_BG_RESOURCE) ?: 0
        } catch (e: Exception) {
            0
        }
        if (bgResource > 0) {
            layout.setBackgroundResource(bgResource)
        } else {
            layout.setBackgroundDrawable(null)
        }
        radius = cell?.optDoubleParam(SimpleGridCellBean.KEY_CARD_RADIUS)?.toFloat() ?: 0f
//        cardElevation = cell?.optDoubleParam(SimpleGridCellBean.KEY_CARD_CARD_ELEVATION)?.toFloat() ?: 0f
        bindImageView(cell)
        bindText(cell, title)
        bindText(cell, content)
        setOnClickListener(cell)
    }

    private fun bindText(cell: BaseCell<*>?, textView: TextView) {
        val centerFlag = cell?.optBoolParam(SimpleGridCellBean.KEY_TEXT_CENTER_FLAG)
        val textGravity = if (centerFlag == true) {
            Gravity.CENTER_HORIZONTAL
        } else {
            Gravity.START
        }
        textView.gravity = textGravity
        val textKey = when (textView) {
            title -> SimpleGridCellBean.KEY_TITLE
            content -> SimpleGridCellBean.KEY_CONTENT
            else -> ""
        }
        val text = cell?.optStringParam(textKey)
        //标题设置
        if (text?.isNotEmpty() == true) {
            textView.visibility = View.VISIBLE
            textView.text = text
            val textColor = cell.optIntParam(textKey + SimpleGridCellBean.KEY_TEXT_COLOR)
            if (textColor != 0) {
                textView.setTextColor(textColor)
            } else {
                textView.setTextColor(Color.BLACK)
            }
            val textSize = cell.optIntParam(textKey + SimpleGridCellBean.KEY_TEXT_SIZE)
            if (textSize > 0) {
                textView.textSize = textSize.toFloat()
            } else {
                textView.textSize = 12f
            }
            val textMaxLine = cell.optIntParam(textKey + SimpleGridCellBean.KEY_TEXT_MAX_LINE)
            if (textMaxLine > 0) {
                textView.maxLines = textMaxLine
                textView.minLines = textMaxLine
            } else {
                textView.maxLines = 1
            }
            var margin = cell.optIntParam(textKey + SimpleGridCellBean.KEY_TEXT_MARGIN)
            if (margin < 0) {
                margin = 0
            }
            val layoutParams: MarginLayoutParams = textView.layoutParams as MarginLayoutParams
            layoutParams.topMargin = Utils.dip2px(context, margin.toFloat())
            textView.layoutParams = layoutParams
        } else {
            textView.visibility = View.GONE
        }
    }

    private fun bindImageView(cell: BaseCell<*>?) {
        val imgUrl = cell?.optStringParam(SimpleGridCellBean.KEY_IMG_URL)
        ImageUtils.doLoadImageUrl(imgView, imgUrl)
        val imgScaleType = cell?.optIntParam(SimpleGridCellBean.KEY_IMG_SCALE_TYPE)
        when (imgScaleType) {
            ImageView.ScaleType.FIT_XY.ordinal -> {
                imgView.scaleType = ImageView.ScaleType.FIT_XY
            }
            ImageView.ScaleType.CENTER.ordinal -> {
                imgView.scaleType = ImageView.ScaleType.CENTER
            }
            ImageView.ScaleType.CENTER_INSIDE.ordinal -> {
                imgView.scaleType = ImageView.ScaleType.CENTER_INSIDE
            }
            else -> {
                imgView.scaleType = ImageView.ScaleType.FIT_CENTER
            }
        }
        val imgWidth = cell?.optIntParam(SimpleGridCellBean.KEY_IMG_WIDTH) ?: 0
        val imgHeight = cell?.optIntParam(SimpleGridCellBean.KEY_IMG_HEIGHT) ?: 0
        val imgSquareFlag = cell?.optBoolParam(SimpleGridCellBean.KEY_IMG_SQUARE_FLAG) ?: false
        imgView.squareModeFlag = imgSquareFlag
        val imgCornerFlag = cell?.optBoolParam(SimpleGridCellBean.KEY_IMG_NO_CORNER_FLAG) ?: false
        imgView.cornerFlag = !imgCornerFlag
        val imgMargin = Utils.dip2px(context, cell?.optIntParam(SimpleGridCellBean.KEY_IMG_MARGIN)
                ?: 0)
        val layoutParams: MarginLayoutParams = imgView.layoutParams as MarginLayoutParams
        layoutParams.bottomMargin = 0
        layoutParams.topMargin = imgMargin
        layoutParams.leftMargin = imgMargin
        layoutParams.rightMargin = imgMargin
        //如果固定给了宽高，就设上，没给就回设为初始状态
        if (imgWidth > 0 && imgHeight > 0) {
            layoutParams.width = imgWidth
            layoutParams.height = imgHeight
            if (layoutParams is LinearLayout.LayoutParams) {
                layoutParams.weight = 0f
            }
        } else {
            layoutParams.width = LinearLayout.LayoutParams.MATCH_PARENT
            layoutParams.height = 0
            if (layoutParams is LinearLayout.LayoutParams) {
                layoutParams.weight = 1f
            }
        }
    }

    override fun postUnBindView(cell: BaseCell<*>?) {
        ImageUtils.doLoadImageUrl(imgView, "")
    }

    override fun cellInited(cell: BaseCell<*>?) {
        setOnClickListener(cell)
    }
}