package com.hsh.tangramlibrary.widget

import android.content.Context
import android.support.v7.widget.RecyclerView
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.hsh.tangramlibrary.model.CustomParentCell
import com.hsh.tangramlibrary.utils.TangramViewHelper
import com.tmall.wireless.tangram.core.adapter.BinderViewHolder
import com.tmall.wireless.tangram.structure.BaseCell
import com.tmall.wireless.tangram.structure.view.ITangramViewLifeCycle

/**
 * Created by Administrator on 2018/1/29.
 */
class BannerGroupCellView(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        ITangramViewLifeCycle, LinearLayout(context, attrs, defStyleAttr) {
    constructor(context: Context, attrs: AttributeSet? = null) : this(context, attrs, 0)
    constructor(context: Context) : this(context, null)

    private val viewHolderList: MutableList<BinderViewHolder<*, *>> = mutableListOf()
    private var hGap: Int = 0

    init {
        orientation = HORIZONTAL
    }

    override fun postBindView(cell: BaseCell<*>?) {
        val parentCell = cell as? CustomParentCell ?: return
        val childrenCells = parentCell.childrenCells ?: return
        hGap = cell.style?.extras?.optInt("hGap", 0) ?: 0
        for ((i, child) in childrenCells.withIndex()) {
            val view = getViewFromRecycler(child)
            val viewLifeCycle = view as? ITangramViewLifeCycle
            viewLifeCycle?.postBindView(child)
            var layoutParams: LayoutParams? = view.layoutParams as? LayoutParams
            if (layoutParams == null) {
                layoutParams = LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.MATCH_PARENT)
                view.layoutParams = layoutParams
            }
            layoutParams.weight = 1f
            layoutParams.width = 0
            layoutParams.height = LayoutParams.MATCH_PARENT
            when {
                (i == 0 && childrenCells.size > 1) -> {
                    layoutParams.rightMargin = hGap / 2
                }
                childrenCells.size > 1 && i == childrenCells.size - 1 -> {
                    layoutParams.leftMargin = hGap / 2
                }
                else -> {
                    layoutParams.leftMargin = hGap / 2
                    layoutParams.rightMargin = hGap / 2
                }
            }
            view.setOnClickListener(child)
            addView(view)
        }
    }

    override fun postUnBindView(cell: BaseCell<*>?) {
        removeAllViews()
        for (viewHolder in viewHolderList) {
            val viewLifeCycle = viewHolder.itemView as? ITangramViewLifeCycle
            viewLifeCycle?.postUnBindView(viewHolder.data as? BaseCell<*>)
            viewHolder.itemView.setOnClickListener(null)
        }
        recycleView(cell)
    }

    override fun cellInited(cell: BaseCell<*>?) {
    }

    private fun getViewFromRecycler(cell: BaseCell<*>): View {
        val binderViewHolder = TangramViewHelper.getViewFromRecycler(cell, this)
        viewHolderList.add(binderViewHolder)
        return binderViewHolder.itemView
    }

    private fun recycleView(cell: BaseCell<*>?) {
        if (!viewHolderList.isEmpty()) {
            val pool = cell?.serviceManager?.getService(RecyclerView.RecycledViewPool::class.java)
            var i = 0
            val size = viewHolderList.size
            while (i < size) {
                val viewHolder = viewHolderList[i]
                viewHolder.unbind()
                removeView(viewHolder.itemView)
                pool?.putRecycledView(viewHolder)
                i++
            }
            viewHolderList.clear()
        }
    }

}