package com.hsh.tangramlibrary.widget

import android.content.Context
import android.graphics.Color
import android.support.v7.widget.RecyclerView
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.hsh.tangramlibrary.bean.style.GridCellStyle
import com.hsh.tangramlibrary.model.CustomParentCell
import com.hsh.tangramlibrary.utils.TangramViewHelper
import com.tmall.wireless.tangram.core.adapter.BinderViewHolder
import com.tmall.wireless.tangram.structure.BaseCell
import com.tmall.wireless.tangram.structure.view.ITangramViewLifeCycle

/**
 * Created by Administrator on 2018/1/29.
 */
class BannerGridCellView(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        ITangramViewLifeCycle, LinearLayout(context, attrs, defStyleAttr) {
    constructor(context: Context, attrs: AttributeSet? = null) : this(context, attrs, 0)
    constructor(context: Context) : this(context, null)

    private val viewHolderList: MutableList<BinderViewHolder<*, *>> = mutableListOf()
    private var hGap: Int = 0
    var colNum = 3
    var rowNum = 2
    private val linearLayoutList = mutableListOf<LinearLayout>()

    init {
        orientation = VERTICAL
        for (row in 0 until rowNum) {
            val linearLayout = LinearLayout(context)
            val layoutParams = LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT)
            layoutParams.weight = 1f
            linearLayout.layoutParams = layoutParams
            linearLayout.orientation = HORIZONTAL
            linearLayoutList.add(linearLayout)
            addView(linearLayout)
        }
    }

    override fun postBindView(cell: BaseCell<*>?) {
        val parentCell = cell as? CustomParentCell ?: return
        val childrenCells = parentCell.childrenCells ?: return
        if (childrenCells.size == 0) {
            return
        }
        val padding = cell.style?.padding ?: intArrayOf(0, 0, 0, 0)
        setPadding(padding[0], padding[1], padding[2], padding[3])
        val bgResource = try {
            cell.style?.extras?.getInt(GridCellStyle.KEY_BG_RESOURCE) ?: 0
        } catch (e: Exception) {
            0
        }
        if (bgResource > 0) {
            setBackgroundResource(bgResource)
        }
        hGap = cell.style?.extras?.optInt("hGap", 0) ?: 0
        var childIndex = 0
        for ((row, linearLayout) in linearLayoutList.withIndex()) {
            val layoutParams = linearLayout.layoutParams as LinearLayout.LayoutParams
            when {
                (row == 0 && rowNum > 1) -> {
                    layoutParams.bottomMargin = hGap / 2
                }
                rowNum > 1 && row == rowNum - 1 -> {
                    layoutParams.topMargin = hGap / 2
                }
                else -> {
                    layoutParams.bottomMargin = hGap / 2
                    layoutParams.topMargin = hGap / 2
                }
            }
            linearLayout.layoutParams = layoutParams
            for (i in 0 until colNum) {
                val child = if (childIndex >= childrenCells.size) {
                    childrenCells[0]
                } else {
                    childrenCells[childIndex]
                }
                val childView = getViewFromRecycler(child)
                initViewByCell(childView, child, i)
                if (childIndex >= childrenCells.size) {
                    childView.visibility = View.INVISIBLE
                } else {
                    childView.visibility = View.VISIBLE
                }
                childIndex++
                linearLayout.addView(childView)
            }
        }
    }

    private fun initViewByCell(view: View, child: BaseCell<*>, index: Int): View {
        val viewLifeCycle = view as? ITangramViewLifeCycle
        viewLifeCycle?.postBindView(child)
        var layoutParams: LayoutParams? = view.layoutParams as? LayoutParams
        if (layoutParams == null) {
            layoutParams = LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.MATCH_PARENT)
            view.layoutParams = layoutParams
        }
        layoutParams.weight = 1f
        layoutParams.width = 0
        layoutParams.height = LayoutParams.MATCH_PARENT
        when {
            (index == 0 && colNum > 1) -> {
                layoutParams.rightMargin = hGap / 2
            }
            colNum > 1 && index == colNum - 1 -> {
                layoutParams.leftMargin = hGap / 2
            }
            else -> {
                layoutParams.leftMargin = hGap / 2
                layoutParams.rightMargin = hGap / 2
            }
        }
        view.setOnClickListener(child)
        return view
    }

    override fun postUnBindView(cell: BaseCell<*>?) {
        for (linearLayout in linearLayoutList) {
            linearLayout.removeAllViews()
        }
        for (viewHolder in viewHolderList) {
            val viewLifeCycle = viewHolder.itemView as? ITangramViewLifeCycle
            viewLifeCycle?.postUnBindView(viewHolder.data as? BaseCell<*>)
            viewHolder.itemView.setOnClickListener(null)
        }
        recycleView(cell)
    }

    override fun cellInited(cell: BaseCell<*>?) {
    }

    private fun getViewFromRecycler(cell: BaseCell<*>): View {
        val binderViewHolder = TangramViewHelper.getViewFromRecycler(cell, this)
        viewHolderList.add(binderViewHolder)
        return binderViewHolder.itemView
    }

    private fun recycleView(cell: BaseCell<*>?) {
        if (!viewHolderList.isEmpty()) {
            val pool = cell?.serviceManager?.getService(RecyclerView.RecycledViewPool::class.java)
            var i = 0
            val size = viewHolderList.size
            while (i < size) {
                val viewHolder = viewHolderList[i]
                viewHolder.itemView.visibility = View.VISIBLE
                viewHolder.unbind()
                removeView(viewHolder.itemView)
                pool?.putRecycledView(viewHolder)
                i++
            }
            viewHolderList.clear()
        }
    }

}