package com.hsh.tangramlibrary.utils;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

import com.tmall.wireless.tangram.core.adapter.BinderViewHolder;
import com.tmall.wireless.tangram.core.adapter.GroupBasicAdapter;
import com.tmall.wireless.tangram.structure.BaseCell;

/**
 * Created by Administrator on 2018/1/29.
 */

public class TangramViewHelper {
    public static BinderViewHolder getViewFromRecycler(@NonNull BaseCell cell, @NonNull ViewGroup view) {
        GroupBasicAdapter adapter = cell.serviceManager.getService(GroupBasicAdapter.class);
        RecyclerView.RecycledViewPool pool = cell.serviceManager.getService(RecyclerView.RecycledViewPool.class);
        int itemViewType = adapter.getItemType(cell);
        BinderViewHolder holder = (BinderViewHolder) pool.getRecycledView(itemViewType);
        if (holder == null) {
            holder = (BinderViewHolder) adapter.createViewHolder(view, itemViewType);
        }
        holder.bind(cell);
        return holder;
    }
}
