package com.hsh.tangramlibrary.bean

import android.graphics.Color
import com.hsh.tangramlibrary.widget.SimpleGridCellView

/**
 *
 */
open class SimpleGridCellBean(imgUrl: String? = null, var title: String? = null, aspectRatio: Float? = 1f,
                              jump: String? = null,
                              var imgScaleType: Int? = 0,
                              var imgSquareFlag: Boolean? = false,
                              var imgMargin : Int? = 0,
                              var titleSize: Int? = 12, var titleColor: Int? = Color.BLACK,
                              var titleMaxLine: Int? = 1,
                              var titleMargin: Int? = 0,
                              var content: String? = null,
                              var contentSize: Int? = 12, var contentColor: Int? = Color.BLACK,
                              var contentMaxLine: Int? = 1,
                              var contentMargin: Int? = 0,
                              var textCenterFlag: Boolean? = true,
                              colspan: Int? = 1,
                              var imgWidth : Int? = null,
                              var imgHeight : Int? = null,
                              var radius : Float = 0f,
                              var cardElevation : Float = 0f) :
        GridImageCellBean(colspan, imgUrl, jump, aspectRatio) {
    companion object {
        const val KEY_IMG_URL = "imgUrl"
        const val KEY_IMG_SCALE_TYPE = "imgScaleType"
        const val KEY_IMG_SQUARE_FLAG = "imgSquareFlag"
        const val KEY_IMG_MARGIN = "imgMargin"
        const val KEY_TEXT_CENTER_FLAG = "textCenterFlag"
        const val KEY_TITLE = "title"
        const val KEY_CONTENT = "content"
        const val KEY_TEXT_SIZE = "Size"
        const val KEY_TEXT_COLOR = "Color"
        const val KEY_TEXT_MAX_LINE = "MaxLine"
        const val KEY_TEXT_MARGIN = "Margin"
        const val KEY_IMG_WIDTH = "imgWidth"
        const val KEY_IMG_HEIGHT = "imgHeight"
        const val KEY_CARD_RADIUS = "radius"
        const val KEY_IMG_NO_CORNER_FLAG = "imgNoCornerFlag"
        const val KEY_CARD_CARD_ELEVATION = "cardElevation"
    }

    init {
        type = SimpleGridCellView::class.java.simpleName
    }
}