package com.hsh.tangramlibrary

import android.content.Context
import com.hsh.tangramlibrary.model.CustomParentCell
import com.hsh.tangramlibrary.widget.*
import com.tmall.wireless.tangram.TangramBuilder
import com.tmall.wireless.tangram.structure.card.BannerCard

/**
 * Created by Administrator on 2018/1/19.
 */
class TangramHelper {
    companion object {
        const val TYPE_CAROUSEL_COMPACT = 10
        fun getTangramBuilder(context: Context): TangramBuilder.InnerBuilder {
            val builder = TangramBuilder.newInnerBuilder(context)
            builder.registerCell(TangramBuilder.TYPE_CAROUSEL_CELL, NewBannerView::class.java)
            builder.registerCell(TangramBuilder.TYPE_CONTAINER_BANNER, NewBannerView::class.java)
            builder.registerCard(TYPE_CAROUSEL_COMPACT, NewBannerCard::class.java)
            builder.registerCard(TangramBuilder.TYPE_CONTAINER_BANNER, NewBannerCard::class.java)
            builder.registerCell(SimpleImgView::class.java.simpleName, SimpleImgView::class.java)
            builder.registerCell(NormalImgView::class.java.simpleName, NormalImgView::class.java)
            builder.registerCell(SimpleGridCellView::class.java.simpleName, SimpleGridCellView::class.java)
            builder.registerCell(CustomTitleView::class.java.simpleName, CustomTitleView::class.java)
            builder.registerCell(BannerGroupCellView::class.java.simpleName, CustomParentCell::class.java, BannerGroupCellView::class.java)
            builder.registerCell(BannerGridCellView::class.java.simpleName, CustomParentCell::class.java, BannerGridCellView::class.java)
            return builder
        }
    }
}