/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.id.config;

import com.solarterms.hakuro.web.data.redis.RedisUtils;
import com.solarterms.hakuro.web.id.config.GeneratorProperties;
import com.solarterms.hakuro.web.id.core.IdGen;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;

@ConditionalOnBean(value={RedisTemplate.class})
@EnableConfigurationProperties(value={GeneratorProperties.class})
public class IdGenAutoConfiguration {
    private GeneratorProperties properties;

    public IdGenAutoConfiguration(GeneratorProperties properties) {
        this.properties = properties;
    }

    @Bean(value={"idGen"})
    public IdGen idGen(@Qualifier(value="redisTemplate") RedisTemplate redisTemplate) {
        if (this.properties.getShardingBits() + this.properties.getSeqBits() > 22L) {
            throw new IllegalArgumentException("too long for the total sum of sharding-bits and seq-bits");
        }
        return new IdGen(this.nextSharding(redisTemplate), this.properties);
    }

    private long nextSharding(RedisTemplate redisTemplate) {
        String shardingKey = String.format("%s-%s", RedisUtils.applicationCachePrefix(), "shardingKey");
        long shardingId = redisTemplate.opsForValue().increment((Object)shardingKey, 1L);
        if (shardingId > (1L << (int)this.properties.getShardingBits()) - 1L) {
            redisTemplate.delete((Object)shardingKey);
            shardingId = redisTemplate.opsForValue().increment((Object)shardingKey, 1L);
        }
        return shardingId;
    }
}

