/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.http;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.collections.CollectionUtils;
import com.solarterms.hakuro.framework.utils.converter.BeanUtils;
import com.solarterms.hakuro.framework.utils.converter.JsonUtils;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import com.solarterms.hakuro.web.context.util.ApplicationContextUtils;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    public static <T> ResponseEntity<T> postForText(String url, String data, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpEntity<String> entity = RestTemplateUtils.generateTextEntity(data);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, data, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForJson(String url, Object object, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpEntity<String> entity = RestTemplateUtils.generateJsonEntity(object);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, object, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForJson(String url, Object object, Class<T> responseType, Map<String, String> headers) {
        ResponseEntity responseEntity;
        try {
            HttpEntity<String> entity = RestTemplateUtils.generateJsonEntity(object, headers);
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, object, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForJson(String url, Object object, ParameterizedTypeReference<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpEntity<String> entity = RestTemplateUtils.generateJsonEntity(object);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, object, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForForm(String url, Object object, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.setAll((Map)BeanUtils.convert((Object)object, Map.class));
            HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, object, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForMap(String url, Map mapParam, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.setAll(mapParam);
            HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, mapParam, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForFile(String url, byte[] file, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            ByteArrayResource bar = new ByteArrayResource(file);
            HttpEntity entity = new HttpEntity((Object)bar);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, "[file]", e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForMultiPart(String url, MultiValueMap<String, Object> mapParam, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            HttpEntity entity = new HttpEntity(mapParam, (MultiValueMap)headers);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, mapParam, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> postForMultiPart(String url, MultiValueMap<String, Object> mapParam, HttpHeaders headers, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            HttpEntity entity = new HttpEntity(mapParam, (MultiValueMap)headers);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).exchange(url, HttpMethod.POST, entity, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", entity, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, mapParam, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Object object, Class<T> responseType) {
        Map params = (Map)BeanUtils.convert((Object)object, LinkedHashMap.class);
        return RestTemplateUtils.getForEntity(url, params, responseType);
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Map<String, String> params, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            String generateUrl = RestTemplateUtils.createUrlWithParameters(url, params);
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).getForEntity(generateUrl, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", params, "\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, params, e);
        }
        return responseEntity;
    }

    private static HttpEntity<String> generateJsonEntity(Object object, Map<String, String> headerParams) {
        String jsonString = object instanceof String ? (String)object : JsonUtils.toNonNullJsonString((Object)object);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headerParams.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        return new HttpEntity((Object)jsonString, (MultiValueMap)headers);
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).getForEntity(url, responseType, new Object[0]);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1anull\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(url, null, e);
        }
        return responseEntity;
    }

    public static <T> ResponseEntity<T> getForEntity(URI uri, Class<T> responseType) {
        ResponseEntity responseEntity;
        try {
            long start = System.currentTimeMillis();
            responseEntity = ((RestTemplate)ApplicationContextUtils.getBean("restTemplate")).getForEntity(uri, responseType);
            long end = System.currentTimeMillis();
            LogUtils.info((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\uff0curl\uff1a", uri.getPath(), "\uff1b\u8bf7\u6c42\uff1anull\uff1b\u54cd\u5e94\uff1a", responseEntity, "\uff1b\u8017\u65f6\uff1a", end - start});
        }
        catch (Exception e) {
            responseEntity = RestTemplateUtils.handleException(uri.toString(), null, e);
        }
        return responseEntity;
    }

    private static HttpEntity<String> generateTextEntity(String data) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"text/plain; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return new HttpEntity((Object)data, (MultiValueMap)headers);
    }

    private static HttpEntity<String> generateJsonEntity(Object object) {
        String jsonString = object instanceof String ? (String)object : JsonUtils.toNonNullJsonString((Object)object);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return new HttpEntity((Object)jsonString, (MultiValueMap)headers);
    }

    private static ResponseEntity handleException(String url, Object requestBody, Exception e) {
        ResponseEntity responseEntity = e instanceof HttpStatusCodeException ? new ResponseEntity((Object)((HttpStatusCodeException)e).getResponseBodyAsString(), ((HttpStatusCodeException)e).getStatusCode()) : (e.getCause() instanceof SocketTimeoutException ? new ResponseEntity(HttpStatus.REQUEST_TIMEOUT) : new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE));
        LogUtils.error((Logger)Log.REST_CONNECTION_LOGGER, (Object[])new Object[]{"http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0curl\uff1a", url, "\uff1b\u8bf7\u6c42\uff1a", JsonUtils.toNonNullJsonString((Object)requestBody), "\uff1b\u54cd\u5e94\uff1a", responseEntity.getBody(), "\uff1b\u5f02\u5e38\uff1a", e.getMessage()});
        String message = String.format("%s\u53d1\u751f\u5f02\u5e38\u8bf7\u6c42\uff0c\u54cd\u5e94\u7801\uff1a%s", RestTemplateUtils.getHostUrl(url), responseEntity.getStatusCode());
        return responseEntity;
    }

    private static String getHostUrl(String link) {
        String hostUrl = link;
        try {
            URL url = new URL(link);
            hostUrl = String.format("%s://%s%s:%d", url.getProtocol(), url.getHost(), url.getPath(), url.getPort());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return hostUrl;
    }

    public static String createUrlWithParameters(String url, Map<String, String> parameters) {
        StringBuffer sb = new StringBuffer(url).append("?");
        parameters.forEach((k, v) -> {
            if (StringUtils.isNotBlank((CharSequence)k) && StringUtils.isNotEmpty((CharSequence)v)) {
                sb.append((String)k).append("=").append((String)v).append("&");
            }
        });
        return sb.substring(0, sb.length() - 1);
    }

    public static String createUrlWithParameters(String url, Object object) {
        Map params = (Map)BeanUtils.convert((Object)object, Map.class);
        return RestTemplateUtils.createUrlWithParameters(url, params);
    }

    public static String createUrlWithSortedParameters(String url, LinkedHashMap<String, String> parameters) {
        ArrayList<Map.Entry<String, String>> paramList = new ArrayList<Map.Entry<String, String>>(parameters.entrySet());
        CollectionUtils.sort(paramList, Comparator.comparing(o -> (String)o.getKey()));
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : paramList) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            buf.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        StringBuilder resultBuffer = new StringBuilder().append(url).append("?").append(buf.toString());
        return resultBuffer.deleteCharAt(resultBuffer.length() - 1).toString();
    }

    public static String createUrlWithSortedParameters(String url, Object object) {
        LinkedHashMap params = (LinkedHashMap)BeanUtils.convert((Object)object, LinkedHashMap.class);
        return RestTemplateUtils.createUrlWithSortedParameters(url, params);
    }

    public static String createSortedParameters(Object object) {
        LinkedHashMap params = (LinkedHashMap)BeanUtils.convert((Object)object, LinkedHashMap.class);
        return RestTemplateUtils.createSortedParameters(params);
    }

    public static String createSortedParameters(LinkedHashMap<String, String> parameters) {
        ArrayList<Map.Entry<String, String>> paramList = new ArrayList<Map.Entry<String, String>>(parameters.entrySet());
        CollectionUtils.sort(paramList, Comparator.comparing(o -> (String)o.getKey()));
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : paramList) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            buf.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        StringBuilder resultBuffer = new StringBuilder().append(buf.toString());
        return resultBuffer.deleteCharAt(resultBuffer.length() - 1).toString();
    }

    public static void main(String[] args) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("versionNo", "1.03");
        params.put("channelId", "10000000012");
        params.put("merchId", "1000010");
        params.put("identityRole", "1");
        params.put("userID", "111_130124199104050015");
        String result = RestTemplateUtils.createUrlWithSortedParameters("", params);
        System.out.println(result);
    }
}

