/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.http;

import com.solarterms.hakuro.web.http.RestTemplateCondition;
import com.solarterms.hakuro.web.http.RestTemplateProperties;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@Conditional(value={RestTemplateCondition.class})
@EnableConfigurationProperties(value={RestTemplateProperties.class})
public class RestTemplateAutoConfiguration {
    private RestTemplateProperties properties;

    public RestTemplateAutoConfiguration(RestTemplateProperties properties) {
        this.properties = properties;
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpRequestFactory());
        restTemplate.getMessageConverters().forEach(httpMessageConverter -> {
            if (httpMessageConverter instanceof StringHttpMessageConverter) {
                ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8);
            }
        });
        return restTemplate;
    }

    private HttpComponentsClientHttpRequestFactory httpRequestFactory() {
        PoolingHttpClientConnectionManager poolManager = new PoolingHttpClientConnectionManager();
        poolManager.setMaxTotal(this.properties.getMaxTotal());
        poolManager.setDefaultMaxPerRoute(this.properties.getMaxPerRoute());
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(this.properties.getConnectTimeout());
        factory.setReadTimeout(this.properties.getReadTimeout());
        factory.setConnectionRequestTimeout(this.properties.getConnectionRequestTimeout());
        SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(SSLContexts.createDefault(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sf).setConnectionManager((HttpClientConnectionManager)poolManager).build();
        factory.setHttpClient((HttpClient)httpClient);
        return factory;
    }
}

