/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.data.redis;

import com.fasterxml.jackson.databind.JavaType;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.lang.Nullable;

public class JsonOrStringRedisSerializer<T>
extends Jackson2JsonRedisSerializer<T> {
    public JsonOrStringRedisSerializer(Class<T> type) {
        super(type);
    }

    public JsonOrStringRedisSerializer(JavaType javaType) {
        super(javaType);
    }

    public T deserialize(@Nullable byte[] bytes) throws SerializationException {
        try {
            return (T)super.deserialize(bytes);
        }
        catch (SerializationException e) {
            return (T)this.deserializeString(bytes);
        }
    }

    private String deserializeString(@Nullable byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes);
    }
}

