/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.ctx;

import com.solarterms.hakuro.framework.utils.function.StringUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextHolder {
    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = org.springframework.web.context.request.RequestContextHolder.getRequestAttributes();
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static HttpMethod getMethodType() {
        return HttpMethod.resolve((String)RequestContextHolder.getRequest().getMethod());
    }

    public static String getParameter(String name) {
        HttpServletRequest request = RequestContextHolder.getRequest();
        return request != null ? request.getParameter(name) : null;
    }

    public static String getHeader(String name) {
        HttpServletRequest request = RequestContextHolder.getRequest();
        return request != null ? request.getHeader(name) : null;
    }

    public static Map<String, String> getHeaderMap() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        HttpServletRequest request = RequestContextHolder.getRequest();
        if (request != null) {
            Enumeration names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                headerMap.put(name, request.getHeader(name));
            }
        }
        return headerMap;
    }

    public static String getRemoteAddr() {
        HttpServletRequest request = RequestContextHolder.getRequest();
        return request != null ? request.getRemoteAddr() : null;
    }

    public static String getPath() {
        HttpServletRequest request = RequestContextHolder.getRequest();
        return request != null ? request.getServletPath() : null;
    }

    public static String getUrl() {
        HttpServletRequest request = RequestContextHolder.getRequest();
        if (request != null) {
            String orgUrl = request.getHeader("request_url");
            if (!StringUtils.isEmpty((CharSequence)orgUrl)) {
                return orgUrl;
            }
            StringBuffer url = request.getRequestURL();
            if (!StringUtils.isEmpty((CharSequence)request.getQueryString())) {
                url.append('?');
                url.append(request.getQueryString());
            }
            return url.toString();
        }
        return null;
    }
}

