/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class MemoryCache {
    private Cache<String, Object> cacheManager;

    public MemoryCache() {
        this.cacheManager = CacheBuilder.newBuilder().build();
    }

    public MemoryCache(Long duration, TimeUnit timeUnit) {
        this.cacheManager = CacheBuilder.newBuilder().expireAfterWrite(duration.longValue(), timeUnit).build();
    }

    public <T> T get(String key, Supplier<T> supplier, Class<T> clazz) {
        try {
            Object o = this.cacheManager.get((Object)key, supplier::get);
            return clazz.cast(o);
        }
        catch (Exception e) {
            LogUtils.error((Logger)Log.ERROR_LOGGER, (Object[])new Object[]{"\u83b7\u53d6\u7f13\u5b58\u53d1\u9001\u5f02\u5e38", e});
            return null;
        }
    }
}

