/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.validation.annotation.URL;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class URLConstraintValidator
implements ConstraintValidator<URL, String> {
    private static final Pattern URL_PATTERN = Pattern.compile("^http[s]?://([\\w-]+\\.)+[\\w-]+([\\w-./?%&=#]*)?$");

    public void initialize(URL constraintAnnotation) {
    }

    public boolean isValid(String url, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return URL_PATTERN.matcher(url).matches();
    }

    public static void main(String[] args) {
        URLConstraintValidator x = new URLConstraintValidator();
        System.out.println(x.isValid("http://www.baidu.com/notify/", null));
    }
}

