/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.validation.annotation.Password;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class PasswordConstraintValidator
implements ConstraintValidator<Password, String> {
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("^(?![0-9]+$)(?![a-zA-Z]+$)[a-zA-Z0-9]{6,20}$");

    public void initialize(Password constraintAnnotation) {
    }

    public boolean isValid(String password, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return false;
        }
        return PASSWORD_PATTERN.matcher(password).matches();
    }

    public static void main(String[] args) {
        PasswordConstraintValidator x = new PasswordConstraintValidator();
        System.out.println(x.isValid(null, null));
    }
}

