/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.validation.annotation.OnlineBankPwdString;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class OnlineBankPwdStringConstraintValidator
implements ConstraintValidator<OnlineBankPwdString, String> {
    private static final Pattern ALPHABET_OR_NUMBER_PATTERN = Pattern.compile("^[0-9A-Za-z]{6,20}$");

    public void initialize(OnlineBankPwdString constraintAnnotation) {
    }

    public boolean isValid(String pwd, ConstraintValidatorContext constraintValidatorContext) {
        return StringUtils.isNotEmpty((CharSequence)pwd) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pwd}) && ALPHABET_OR_NUMBER_PATTERN.matcher(pwd).matches();
    }
}

