/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.core.bean.Money;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.framework.utils.math.MoneyUtils;
import com.solarterms.hakuro.web.bean.validation.annotation.MoneyString;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class MoneyStringConstraintValidator
implements ConstraintValidator<MoneyString, String> {
    private int max;

    public void initialize(MoneyString ann) {
        this.max = ann.max();
    }

    public boolean isValid(String moneyString, ConstraintValidatorContext context) {
        if (StringUtils.isEmpty((CharSequence)moneyString)) {
            return false;
        }
        if (StringUtils.startsWith((CharSequence)moneyString, (CharSequence)".") || StringUtils.endsWith((CharSequence)moneyString, (CharSequence)".")) {
            return false;
        }
        try {
            Money money = MoneyUtils.createMoney((String)moneyString);
            assert (money != null);
            if (String.valueOf(money.longValue()).length() > this.max - 2) {
                return false;
            }
        }
        catch (Exception e) {
            Log.ERROR_LOGGER.error("\u91d1\u989d\u8f6c\u6362\u51fa\u9519:" + moneyString);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        MoneyStringConstraintValidator x = new MoneyStringConstraintValidator();
        System.out.println(x.isValid("200", null));
    }
}

