/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.datetime.DateUtils;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.web.bean.validation.annotation.DateString;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class DateStringConstraintValidator
implements ConstraintValidator<DateString, String> {
    private String format;
    private boolean required;
    private boolean blankValid;

    public void initialize(DateString ann) {
        this.format = ann.format();
        this.required = ann.required();
        this.blankValid = ann.blankValid();
    }

    public boolean isValid(String dateString, ConstraintValidatorContext context) {
        if (dateString == null) {
            return !this.required;
        }
        if (this.blankValid && StringUtils.isBlank((CharSequence)dateString)) {
            return true;
        }
        try {
            DateUtils.parseToDate((String)dateString, (String)this.format);
            return true;
        }
        catch (Exception e) {
            Log.ERROR_LOGGER.error("\u65e5\u671f\u8f6c\u6362\u51fa\u9519:" + dateString);
            return false;
        }
    }
}

