/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.plugins;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class MapperCommentGenerator
implements CommentGenerator {
    private Properties properties = new Properties();
    private Properties systemPro = System.getProperties();
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;
    private String currentDateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    private String beginningDelimiter = "";
    private String endingDelimiter = "";
    private boolean forceAnnotation;

    public void addConfigurationProperties(Properties properties) {
        String forceAnnotation;
        String endingDelimiter;
        this.properties.putAll((Map<?, ?>)properties);
        this.suppressDate = StringUtility.isTrue((String)properties.getProperty("suppressDate"));
        this.suppressAllComments = StringUtility.isTrue((String)properties.getProperty("suppressAllComments"));
        String beginningDelimiter = properties.getProperty("beginningDelimiter");
        if (StringUtility.stringHasValue((String)beginningDelimiter)) {
            this.beginningDelimiter = beginningDelimiter;
        }
        if (StringUtility.stringHasValue((String)(endingDelimiter = properties.getProperty("endingDelimiter")))) {
            this.endingDelimiter = endingDelimiter;
        }
        if (StringUtility.stringHasValue((String)(forceAnnotation = properties.getProperty("forceAnnotation")))) {
            this.forceAnnotation = "TRUE".equalsIgnoreCase(forceAnnotation);
        }
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue((String)introspectedColumn.getRemarks())) {
            field.addJavaDocLine("/**");
            String sb = " * " + introspectedColumn.getRemarks();
            field.addJavaDocLine(sb);
            field.addJavaDocLine("*/");
        }
        if (field.isTransient()) {
            field.addAnnotation("@Transient");
        }
        if (introspectedColumn.isIdentity()) {
            if ("JDBC".equals(introspectedTable.getTableConfiguration().getGeneratedKey().getRuntimeSqlStatement())) {
                field.addAnnotation("@GeneratedValue(generator = \"JDBC\")");
            } else {
                field.addAnnotation("@GeneratedValue(strategy = GenerationType.IDENTITY)");
            }
        } else if (introspectedColumn.isSequenceColumn()) {
            String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
            String sql = MessageFormat.format(introspectedTable.getTableConfiguration().getGeneratedKey().getRuntimeSqlStatement(), tableName, tableName.toUpperCase());
            field.addAnnotation("@GeneratedValue(strategy = GenerationType.IDENTITY, generator = \"" + sql + "\")");
        }
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        this.processClassComment(innerClass, introspectedTable);
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
        this.processClassComment(innerClass, introspectedTable);
    }

    private void processClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerClass.addJavaDocLine("/**");
        sb.append(" * ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerClass.addJavaDocLine(sb.toString());
        sb.setLength(0);
        sb.append(" * @author ");
        sb.append(this.systemPro.getProperty("user.name"));
        sb.append(" ");
        sb.append(this.currentDateStr);
        innerClass.addJavaDocLine(" */");
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
    }

    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
    }

    public void addComment(XmlElement xmlElement) {
        xmlElement.addElement((VisitableElement)new TextElement("<!--"));
        String sb = "  WARNING - @mbg.generated";
        xmlElement.addElement((VisitableElement)new TextElement(sb));
        xmlElement.addElement((VisitableElement)new TextElement("-->"));
    }

    public void addRootComment(XmlElement rootElement) {
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> set) {
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> set) {
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> set) {
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> set) {
    }

    public void addClassAnnotation(InnerClass innerClass, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> set) {
    }
}

