/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.id.core;

import com.solarterms.hakuro.web.id.config.GeneratorProperties;

public class IdGen {
    private GeneratorProperties properties;
    private long lastTimestamp;
    private long shardingId;
    private long sequenceId;

    public IdGen(long shardingId, GeneratorProperties properties) {
        this.properties = properties;
        this.lastTimestamp = 0L;
        this.shardingId = shardingId;
        this.sequenceId = 0L;
    }

    public synchronized long next() {
        return this.next(System.currentTimeMillis());
    }

    private long next(long timestamp) {
        if (timestamp > this.lastTimestamp) {
            this.sequenceId = 0L;
            this.lastTimestamp = timestamp;
        } else if (timestamp == this.lastTimestamp) {
            if (this.sequenceId >= (1L << (int)this.properties.getSeqBits()) - 1L) {
                return this.next(this.tilNextMillis(this.lastTimestamp));
            }
            ++this.sequenceId;
        } else {
            throw new IllegalStateException("timestamp error");
        }
        return timestamp - this.properties.getStartTime() << (int)(this.properties.getShardingBits() + this.properties.getSeqBits()) | this.shardingId << (int)this.properties.getSeqBits() | this.sequenceId;
    }

    private long tilNextMillis(long current) {
        long next = System.currentTimeMillis();
        while (next <= current) {
            next = System.currentTimeMillis();
        }
        return next;
    }
}

