/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.db.typehandler;

import com.solarterms.hakuro.framework.core.interfaces.Typeable;
import com.solarterms.hakuro.framework.utils.function.TypeBeanUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class TypeCodeTypeHandler<E extends Typeable>
extends BaseTypeHandler<E> {
    private Class<E> type;
    private final Map<Object, E> enums;

    public TypeCodeTypeHandler(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type argument cannot be null");
        }
        List enumList = TypeBeanUtils.getEnumList((Class)type);
        HashMap<Object, E> temp = new HashMap<Object, E>();
        for (Typeable each : enumList) {
            temp.put(each.getCode(), each);
        }
        this.type = type;
        this.enums = temp;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        ps.setObject(i, parameter.getCode());
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String code = rs.getString(columnName);
        if (rs.wasNull()) {
            return null;
        }
        try {
            return (E)((Typeable)this.enums.get(code));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert " + code + " to " + this.type.getSimpleName() + " by code value.", ex);
        }
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String code = rs.getString(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        try {
            return (E)((Typeable)this.enums.get(code));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert " + code + " to " + this.type.getSimpleName() + " by code value.", ex);
        }
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String code = cs.getString(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        try {
            return (E)((Typeable)this.enums.get(code));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert " + code + " to " + this.type.getSimpleName() + " by code value.", ex);
        }
    }
}

