/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.data.redis;

import com.solarterms.hakuro.web.context.util.ApplicationContextUtils;
import com.solarterms.hakuro.web.data.redis.RedisClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class RedisUtils {
    public static String applicationCachePrefix() {
        return String.format("%s-%s", ApplicationContextUtils.getProperties("spring.application.name"), ApplicationContextUtils.getProperties("spring.profiles.active"));
    }

    public static <T> T get(String key, Supplier<T> func) {
        Object obj = RedisClient.get(key);
        if (obj == null) {
            obj = func.get();
            RedisClient.set(key, obj);
        }
        return (T)obj;
    }

    public static <T> T get(String key, Supplier<T> func, long expire, TimeUnit timeUnit) {
        Object obj = RedisClient.get(key);
        if (obj == null) {
            obj = func.get();
            RedisClient.set(key, obj, expire, timeUnit);
        }
        return (T)obj;
    }
}

