/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.data.redis;

import com.solarterms.hakuro.web.context.util.ApplicationContextUtils;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public abstract class RedisClient {
    private static RedisTemplate getRedisTemplate() {
        RedisTemplate redisTemplate = (RedisTemplate)ApplicationContextUtils.getBean("redisTemplate");
        Assert.notNull((Object)redisTemplate, (String)"\u83b7\u53d6RedisTemplate\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5redis\u76f8\u5173\u4f9d\u8d56\u548c\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6b63\u5e38");
        return redisTemplate;
    }

    public static void set(Object key, Object value) {
        RedisClient.getRedisTemplate().opsForValue().set(key, value);
    }

    public static void set(Object key, Object value, long expire, TimeUnit timeUnit) {
        RedisClient.getRedisTemplate().opsForValue().set(key, value, expire, timeUnit);
    }

    public static Boolean expire(Object key, long expire, TimeUnit timeUnit) {
        return RedisClient.getRedisTemplate().expire(key, expire, timeUnit);
    }

    public static Boolean expireIfInexistence(Object key, long expire, TimeUnit timeUnit) {
        return RedisClient.getRedisTemplate().hasKey(key) != false ? true : RedisClient.getRedisTemplate().expire(key, expire, timeUnit);
    }

    public static Boolean expireAt(Object key, Date expireAt) {
        return RedisClient.getRedisTemplate().expireAt(key, expireAt);
    }

    public static Object get(Object key) {
        return RedisClient.getRedisTemplate().opsForValue().get(key);
    }

    public static boolean exists(Object key) {
        return RedisClient.getRedisTemplate().hasKey(key);
    }

    public static boolean delete(Object key) {
        RedisClient.getRedisTemplate().delete(key);
        return !RedisClient.exists(key);
    }

    public static Map<Object, Object> entries(Object key) {
        return RedisClient.getRedisTemplate().opsForHash().entries(key);
    }

    public static void put(Object key, Object k, Object v) {
        RedisClient.getRedisTemplate().opsForHash().put(key, k, v);
    }

    public static void putAll(Object key, Map<?, ?> map) {
        RedisTemplate redisTemplate = RedisClient.getRedisTemplate();
        if (map.isEmpty()) {
            return;
        }
        byte[] rawKey = redisTemplate.getKeySerializer().serialize(key);
        AbstractMap hashes = map instanceof ConcurrentHashMap ? new ConcurrentHashMap(map.size()) : new LinkedHashMap(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            hashes.put(redisTemplate.getHashKeySerializer().serialize(entry.getKey()), redisTemplate.getHashValueSerializer().serialize(entry.getValue()));
        }
        redisTemplate.execute(connection -> {
            connection.hMSet(rawKey, hashes);
            return null;
        }, true);
    }

    public static Long increment(Object key) {
        return RedisClient.getRedisTemplate().opsForValue().increment(key, 1L);
    }

    public static Long increment(Object key, Long k) {
        return RedisClient.getRedisTemplate().opsForValue().increment(key, k.longValue());
    }

    public static Long decrease(Object key) {
        return RedisClient.getRedisTemplate().opsForValue().increment(key, -1L);
    }

    public static Integer pipeLinedSet(Map<Object, Object> entries) {
        RedisTemplate redisTemplate = RedisClient.getRedisTemplate();
        return redisTemplate.executePipelined(connection -> {
            for (Map.Entry entry : entries.entrySet()) {
                connection.set(redisTemplate.getKeySerializer().serialize(entry.getKey()), redisTemplate.getValueSerializer().serialize(entry.getValue()));
            }
            return null;
        }).size();
    }

    public static Map<Object, Object> pipeLinedGet(Set<Object> keys) {
        Object[] keysArray = keys.toArray();
        RedisTemplate redisTemplate = RedisClient.getRedisTemplate();
        List resultList = redisTemplate.executePipelined(connection -> {
            for (Object o : keysArray) {
                connection.get(redisTemplate.getKeySerializer().serialize(o));
            }
            return null;
        });
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        for (int i = 0; i < keysArray.length; ++i) {
            if (null == resultList.get(i)) continue;
            resultMap.put(keysArray[i], resultList.get(i));
        }
        return resultMap;
    }

    public static Set<Object> getKeysByPattern(String pattern) {
        return RedisClient.getRedisTemplate().keys((Object)pattern);
    }

    public static void deleteByPattern(String pattern) {
        RedisTemplate redisTemplate = RedisClient.getRedisTemplate();
        Set keys = redisTemplate.keys((Object)pattern);
        redisTemplate.delete((Collection)keys);
    }

    public static boolean setNX(Object key, Object value) {
        return RedisClient.getRedisTemplate().opsForValue().setIfAbsent(key, value);
    }

    public static boolean setNX(Object key, Object value, long expire, TimeUnit timeUnit) {
        RedisTemplate redisTemplate = RedisClient.getRedisTemplate();
        Boolean result = (Boolean)redisTemplate.execute(connection -> {
            Object obj = connection.execute("set", (byte[][])new byte[][]{redisTemplate.getKeySerializer().serialize(key), redisTemplate.getValueSerializer().serialize(value), "NX".getBytes(), "EX".getBytes(), redisTemplate.getValueSerializer().serialize((Object)timeUnit.toSeconds(expire))});
            return obj != null;
        });
        return result == null ? false : result;
    }

    public static int getExpireHours(Object key) {
        return RedisClient.getRedisTemplate().getExpire(key, TimeUnit.HOURS).intValue();
    }

    public static Long getExpireMinutes(Object key) {
        return RedisClient.getRedisTemplate().getExpire(key, TimeUnit.MINUTES);
    }

    public static Map hGetAll(Object key) {
        return RedisClient.getRedisTemplate().opsForHash().entries(key);
    }

    public static Object hGet(Object key, Object hashKey) {
        return RedisClient.getRedisTemplate().opsForHash().get(key, hashKey);
    }

    public static boolean hExists(Object key, Object hashKey) {
        return RedisClient.getRedisTemplate().opsForHash().hasKey(key, hashKey);
    }

    public static Long hDelete(Object key, Object hashKey) {
        return RedisClient.getRedisTemplate().opsForHash().delete(key, new Object[]{hashKey});
    }

    public static Long lpush(Object key, Object value) {
        return RedisClient.getRedisTemplate().opsForList().leftPush(key, value);
    }

    public static Long lpushAll(Object key, Object ... values) {
        return RedisClient.getRedisTemplate().opsForList().leftPushAll(key, values);
    }

    public static Long lpushAll(Object key, Collection<Object> values) {
        return RedisClient.getRedisTemplate().opsForList().leftPushAll(key, values);
    }

    public static Object rpop(Object key) {
        return RedisClient.getRedisTemplate().opsForList().rightPop(key);
    }

    public static Object brpop(Object key, long timeout, TimeUnit timeUnit) {
        RedisTemplate redisTemplate = RedisClient.getRedisTemplate();
        List pipeLinedResult = redisTemplate.executePipelined(connection -> {
            List r = connection.bRPop((int)timeUnit.toSeconds(timeout), (byte[][])new byte[][]{redisTemplate.getKeySerializer().serialize(key)});
            return r == null || r.isEmpty() ? null : r;
        });
        if (pipeLinedResult.isEmpty() || pipeLinedResult.get(0) == null) {
            return null;
        }
        return ((List)pipeLinedResult.get(0)).get(1);
    }

    public static void publish(String channel, Object message) {
        RedisClient.getRedisTemplate().convertAndSend(channel, message);
    }
}

