/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.common;

import com.solarterms.hakuro.framework.utils.function.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;

public class IpAddressUtils {
    public static final String X_FORWARDED_FOR = "x-forwarded-for";
    private static final String UNKNOWN_STRING = "unknown";

    public static String getHostAddress() {
        try {
            return Objects.requireNonNull(IpAddressUtils.getLocalHostAddress()).getHostAddress();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getClientAddress(HttpServletRequest request) {
        return IpAddressUtils.getClientAddressByRealIp(request, X_FORWARDED_FOR);
    }

    private static String getClientAddressByRealIp(HttpServletRequest request, String addressType) {
        String ip = request.getHeader(addressType);
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN_STRING.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN_STRING.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN_STRING.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    private static InetAddress getLocalHostAddress() {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address.getHostAddress().contains(".")) {
                        String prefix = address.getHostAddress().substring(0, address.getHostAddress().indexOf("."));
                        if (!NumberUtils.isParsable((String)prefix)) continue;
                        return address;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = address;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(IpAddressUtils.getLocalHostAddress());
    }
}

